/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.chemical;

import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.common.attachments.containers.ComponentBackedContainer;
import mekanism.common.attachments.containers.IAttachedContainers;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class ComponentBackedChemicalTank<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, ATTACHED extends IAttachedContainers<STACK, ATTACHED>>
extends ComponentBackedContainer<STACK, ATTACHED>
implements IChemicalTank<CHEMICAL, STACK> {
    private final BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract;
    private final BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canInsert;
    private final Predicate<@NotNull CHEMICAL> validator;
    @Nullable
    private final ChemicalAttributeValidator attributeValidator;
    private final LongSupplier capacity;
    private final LongSupplier rate;

    protected ComponentBackedChemicalTank(ItemStack attachedTo, int tankIndex, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canExtract, BiPredicate<@NotNull CHEMICAL, @NotNull AutomationType> canInsert, Predicate<@NotNull CHEMICAL> validator, LongSupplier rate, LongSupplier capacity, @Nullable ChemicalAttributeValidator attributeValidator) {
        super(attachedTo, tankIndex);
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.validator = validator;
        this.capacity = capacity;
        this.rate = rate;
        this.attributeValidator = attributeValidator;
    }

    @Override
    protected STACK copy(STACK toCopy) {
        return ChemicalUtil.copy(toCopy);
    }

    @Override
    protected boolean isEmpty(STACK value) {
        return ((ChemicalStack)value).isEmpty();
    }

    @Override
    public STACK getStack() {
        return (STACK)((ChemicalStack)this.getContents(this.getAttached()));
    }

    @Override
    public void setStack(STACK stack) {
        this.setStackUnchecked(stack);
    }

    @Override
    public void setStackUnchecked(STACK stack) {
        this.setContents(this.getAttached(), stack);
    }

    @Override
    public ChemicalAttributeValidator getAttributeValidator() {
        return this.attributeValidator == null ? IChemicalTank.super.getAttributeValidator() : this.attributeValidator;
    }

    protected long getInsertRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Long.MAX_VALUE : this.rate.getAsLong();
    }

    protected long getExtractRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Long.MAX_VALUE : this.rate.getAsLong();
    }

    @Override
    public long getCapacity() {
        return this.capacity.getAsLong();
    }

    @Override
    public boolean isValid(STACK stack) {
        return this.getAttributeValidator().process((ChemicalStack<?>)stack) && this.validator.test(((ChemicalStack)stack).getChemical());
    }

    @Override
    public STACK insert(STACK stack, Action action, AutomationType automationType) {
        if (((ChemicalStack)stack).isEmpty() || !this.isValid(stack) || !this.canInsert.test(((ChemicalStack)stack).getChemical(), automationType)) {
            return stack;
        }
        Object attachedChemicals = this.getAttached();
        ChemicalStack stored = (ChemicalStack)this.getContents(attachedChemicals);
        long needed = Math.min(this.getInsertRate(automationType), this.getNeeded(stored));
        if (needed <= 0L) {
            return stack;
        }
        if (stored.isEmpty() || ChemicalStack.isSameChemical(stored, stack)) {
            long toAdd = Math.min(((ChemicalStack)stack).getAmount(), needed);
            if (action.execute()) {
                this.setContents(attachedChemicals, this.createStack(stack, stored.getAmount() + toAdd));
            }
            return this.createStack(stack, ((ChemicalStack)stack).getAmount() - toAdd);
        }
        return stack;
    }

    @Override
    public final STACK extract(long amount, Action action, AutomationType automationType) {
        if (amount < 1L) {
            return this.getEmptyStack();
        }
        Object attachedChemicals = this.getAttached();
        return (STACK)this.extract(attachedChemicals, (ChemicalStack)this.getContents(attachedChemicals), amount, action, automationType);
    }

    protected STACK extract(ATTACHED attachedChemicals, STACK stored, long amount, Action action, AutomationType automationType) {
        if (amount < 1L || ((ChemicalStack)stored).isEmpty() || !this.canExtract.test(((ChemicalStack)stored).getChemical(), automationType)) {
            return this.getEmptyStack();
        }
        long size = Math.min(Math.min(this.getExtractRate(automationType), ((ChemicalStack)stored).getAmount()), amount);
        if (size == 0L) {
            return this.getEmptyStack();
        }
        STACK ret = this.createStack(stored, size);
        if (!((ChemicalStack)ret).isEmpty() && action.execute()) {
            this.setContents(attachedChemicals, this.createStack(stored, ((ChemicalStack)stored).getAmount() - ((ChemicalStack)ret).getAmount()));
        }
        return ret;
    }

    @Override
    public final long setStackSize(long amount, Action action) {
        Object attachedChemicals = this.getAttached();
        return this.setStackSize(attachedChemicals, (ChemicalStack)this.getContents(attachedChemicals), amount, action);
    }

    protected long setStackSize(ATTACHED attachedChemicals, STACK stored, long amount, Action action) {
        if (((ChemicalStack)stored).isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setContents(attachedChemicals, this.getEmptyStack());
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (((ChemicalStack)stored).getAmount() == amount || action.simulate()) {
            return amount;
        }
        this.setContents(attachedChemicals, this.createStack(stored, amount));
        return amount;
    }

    @Override
    public long growStack(long amount, Action action) {
        Object attachedChemicals = this.getAttached();
        ChemicalStack stored = (ChemicalStack)this.getContents(attachedChemicals);
        long current = stored.getAmount();
        if (current == 0L) {
            return 0L;
        }
        if (amount > 0L) {
            amount = Math.min(Math.min(amount, this.getNeeded(stored)), this.getInsertRate(null));
        } else if (amount < 0L) {
            amount = Math.max(amount, -this.getExtractRate(null));
        }
        long newSize = this.setStackSize(attachedChemicals, stored, current + amount, action);
        return newSize - current;
    }

    protected long getNeeded(STACK stored) {
        return Math.max(0L, this.getCapacity() - ((ChemicalStack)stored).getAmount());
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        STACK stored = this.getStack();
        if (!((ChemicalStack)stored).isEmpty()) {
            nbt.put("stored", ((ChemicalStack)stored).save(provider));
        }
        return nbt;
    }
}

