/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.chemical.infuse;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.infuse.AttachedInfuseTypes;
import mekanism.common.attachments.containers.chemical.infuse.ComponentBackedInfusionTank;
import mekanism.common.item.block.ItemBlockChemicalTank;
import mekanism.common.tier.ChemicalTankTier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public class ComponentBackedChemicalTankInfusionTank
extends ComponentBackedInfusionTank {
    private final boolean isCreative;

    public static ComponentBackedChemicalTankInfusionTank create(ContainerType<?, ?, ?> ignored, ItemStack attachedTo, int tankIndex) {
        Item item = attachedTo.getItem();
        if (!(item instanceof ItemBlockChemicalTank)) {
            throw new IllegalStateException("Attached to should always be a chemical tank item");
        }
        ItemBlockChemicalTank item2 = (ItemBlockChemicalTank)item;
        return new ComponentBackedChemicalTankInfusionTank(attachedTo, tankIndex, item2.getTier());
    }

    private ComponentBackedChemicalTankInfusionTank(ItemStack attachedTo, int tankIndex, ChemicalTankTier tier) {
        super(attachedTo, tankIndex, ChemicalTankBuilder.INFUSION.alwaysTrueBi, ChemicalTankBuilder.INFUSION.alwaysTrueBi, ChemicalTankBuilder.INFUSION.alwaysTrue, tier::getOutput, tier::getStorage, tier == ChemicalTankTier.CREATIVE ? ChemicalAttributeValidator.ALWAYS_ALLOW : null);
        this.isCreative = tier == ChemicalTankTier.CREATIVE;
    }

    @Override
    public InfusionStack insert(InfusionStack stack, Action action, AutomationType automationType) {
        return super.insert(stack, action.combine(!this.isCreative), automationType);
    }

    @Override
    public InfusionStack extract(AttachedInfuseTypes attachedInfuseTypes, InfusionStack stored, long amount, Action action, AutomationType automationType) {
        return super.extract(attachedInfuseTypes, stored, amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public long setStackSize(AttachedInfuseTypes attachedInfuseTypes, InfusionStack stored, long amount, Action action) {
        return super.setStackSize(attachedInfuseTypes, stored, amount, action.combine(!this.isCreative));
    }
}

