/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import mekanism.api.functions.ToFloatFunction;
import mekanism.client.sound.PlayerSound;
import mekanism.client.sound.SoundHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.player_data.PacketResetPlayerClient;
import mekanism.common.network.to_server.PacketGearStateUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlayerState {
    private static final ResourceLocation STEP_ASSIST_MODIFIER_ID = Mekanism.rl("step_assist");
    private final Set<UUID> activeJetpacks = new ObjectOpenHashSet();
    private final Set<UUID> activeScubaMasks = new ObjectOpenHashSet();
    private final Set<UUID> activeGravitationalModulators = new ObjectOpenHashSet();
    private LevelAccessor world;

    public void clear(boolean isRemote) {
        this.activeJetpacks.clear();
        this.activeScubaMasks.clear();
        this.activeGravitationalModulators.clear();
        if (isRemote) {
            SoundHandler.clearPlayerSounds();
        }
    }

    public void clearPlayer(UUID uuid, boolean isRemote) {
        this.activeJetpacks.remove(uuid);
        this.activeScubaMasks.remove(uuid);
        this.activeGravitationalModulators.remove(uuid);
        if (isRemote) {
            SoundHandler.clearPlayerSounds(uuid);
            if (Minecraft.getInstance().player == null || Minecraft.getInstance().player.getUUID().equals(uuid)) {
                SoundHandler.radiationSoundMap.clear();
            }
        }
        RadiationManager.get().resetPlayer(uuid);
        if (!isRemote) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PacketResetPlayerClient(uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void init(LevelAccessor world) {
        this.world = world;
    }

    public void setJetpackState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeJetpacks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeJetpacks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeJetpacks.add(uuid);
        }
        if (changed && this.world.isClientSide()) {
            if (isLocal) {
                PacketUtils.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.JETPACK, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.JETPACK);
            }
        }
    }

    public boolean isJetpackOn(Player p) {
        return this.activeJetpacks.contains(p.getUUID());
    }

    public Set<UUID> getActiveJetpacks() {
        return this.activeJetpacks;
    }

    public void setScubaMaskState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeScubaMasks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeScubaMasks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeScubaMasks.add(uuid);
        }
        if (changed && this.world.isClientSide()) {
            if (isLocal) {
                PacketUtils.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.SCUBA_MASK, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.SCUBA_MASK);
            }
        }
    }

    public boolean isScubaMaskOn(Player p) {
        return this.activeScubaMasks.contains(p.getUUID());
    }

    public Set<UUID> getActiveScubaMasks() {
        return this.activeScubaMasks;
    }

    public void updateStepAssist(Player player) {
        this.updateAttribute(player, (Holder<Attribute>)Attributes.STEP_HEIGHT, STEP_ASSIST_MODIFIER_ID, CommonPlayerTickHandler::getStepBoost);
    }

    private void updateAttribute(Player player, Holder<Attribute> attribute, ResourceLocation id, ToFloatFunction<Player> additionalSupplier) {
        AttributeInstance attributeInstance = player.getAttribute(attribute);
        if (attributeInstance != null) {
            AttributeModifier existing = attributeInstance.getModifier(id);
            float additional = additionalSupplier.applyAsFloat(player);
            if (existing != null) {
                if (existing.amount() == (double)additional) {
                    return;
                }
                attributeInstance.removeModifier(id);
            }
            if (additional > 0.0f) {
                attributeInstance.addTransientModifier(new AttributeModifier(id, (double)additional, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    public void setGravitationalModulationState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeGravitationalModulators.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeGravitationalModulators.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeGravitationalModulators.add(uuid);
        }
        if (changed && this.world.isClientSide()) {
            if (isLocal) {
                PacketUtils.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.GRAVITATIONAL_MODULATOR, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.GRAVITATIONAL_MODULATOR);
            }
        }
    }

    public boolean isGravitationalModulationOn(Player p) {
        return this.activeGravitationalModulators.contains(p.getUUID());
    }

    public Set<UUID> getActiveGravitationalModulators() {
        return this.activeGravitationalModulators;
    }
}

