/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import mekanism.api.radiation.IRadiationManager;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.block.attribute.AttributeMultiblock;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.radiation.Meltdown;
import mekanism.common.lib.security.ISecurityTile;
import mekanism.common.network.to_client.security.PacketSyncSecurity;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.interfaces.IComparatorSupport;
import mekanism.common.tile.interfaces.ITileRadioactive;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockMekanism
extends Block {
    protected BlockMekanism(BlockBehaviour.Properties properties) {
        super(BlockStateHelper.applyLightLevelAdjustments(properties));
        this.registerDefaultState(BlockStateHelper.getDefaultState((BlockState)this.stateDefinition.any()));
    }

    @Nullable
    public PushReaction getPistonPushReaction(@NotNull BlockState state) {
        if (state.hasBlockEntity()) {
            return PushReaction.BLOCK;
        }
        return super.getPistonPushReaction(state);
    }

    protected boolean canBeReplaced(@NotNull BlockState state, @NotNull Fluid fluid) {
        return false;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        TileEntityUpdateable tile;
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        if (MekanismConfig.common.copyBlockData.get() && (tile = WorldUtils.getTileEntity(TileEntityUpdateable.class, (BlockGetter)world, pos)) != null) {
            stack.applyComponents(tile.collectComponents());
        }
        return stack;
    }

    protected boolean triggerEvent(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, int id, int param) {
        boolean triggered = super.triggerEvent(state, level, pos, id, param);
        BlockMekanism blockMekanism = this;
        if (blockMekanism instanceof IHasTileEntity) {
            IHasTileEntity hasTileEntity = (IHasTileEntity)((Object)blockMekanism);
            return hasTileEntity.triggerBlockEntityEvent(state, level, pos, id, param);
        }
        return triggered;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        BlockStateHelper.fillBlockStateContainer(this, builder);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return BlockStateHelper.getStateForPlacement(this, super.getStateForPlacement(context), context);
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            return fluidLoggable.getFluid(state);
        }
        return super.getFluidState(state);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Block block = state.getBlock();
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            fluidLoggable.updateFluids(state, world, currentPos);
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        TileEntityUpdateable tile;
        AttributeHasBounding hasBounding;
        if (!state.is(newState.getBlock()) && (hasBounding = Attribute.get(state, AttributeHasBounding.class)) != null) {
            hasBounding.removeBoundingBlocks(world, pos, state);
        }
        if (!(!state.hasBlockEntity() || state.is(newState.getBlock()) && newState.hasBlockEntity() || (tile = WorldUtils.getTileEntity(TileEntityUpdateable.class, (BlockGetter)world, pos)) == null)) {
            tile.blockRemoved();
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        TileEntityUpdateable tile;
        super.setPlacedBy(world, pos, state, placer, stack);
        AttributeHasBounding hasBounding = Attribute.get(state, AttributeHasBounding.class);
        if (hasBounding != null) {
            hasBounding.placeBoundingBlocks(world, pos, state);
        }
        if ((tile = WorldUtils.getTileEntity(TileEntityUpdateable.class, (BlockGetter)world, pos)) != null) {
            ISecurityTile securityTile;
            tile.onAdded();
            if (tile instanceof ISecurityTile && (securityTile = (ISecurityTile)((Object)tile)).getOwnerUUID() == null && placer != null) {
                securityTile.setOwnerUUID(placer.getUUID());
                if (!world.isClientSide) {
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PacketSyncSecurity(placer.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    public void onBlockExploded(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Explosion explosion) {
        Meltdown.MeltdownExplosion meltdown;
        MultiblockData multiblock;
        AttributeMultiblock multiblockAttribute;
        if (!world.isClientSide && (multiblockAttribute = Attribute.get(state, AttributeMultiblock.class)) != null && explosion instanceof Meltdown.MeltdownExplosion && (multiblock = multiblockAttribute.getMultiblock(world, pos, (meltdown = (Meltdown.MeltdownExplosion)explosion).getMultiblockID())) != null) {
            multiblock.meltdownHappened(world);
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull Rotation rotation) {
        return AttributeStateFacing.rotate(state, world, pos, rotation);
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        return AttributeStateFacing.rotate(state, rotation);
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        return AttributeStateFacing.mirror(state, mirror);
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState blockState) {
        return Attribute.has(this, Attributes.AttributeComparator.class);
    }

    protected int getAnalogOutputSignal(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos pos) {
        IComparatorSupport comparatorTile;
        BlockEntity tile;
        if (this.hasAnalogOutputSignal(blockState) && (tile = WorldUtils.getTileEntity((BlockGetter)world, pos)) instanceof IComparatorSupport && (comparatorTile = (IComparatorSupport)tile).supportsComparator()) {
            return comparatorTile.getCurrentRedstoneLevel();
        }
        return 0;
    }

    protected float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos) {
        return this.getDestroyProgress(state, player, blockGetter, pos, state.hasBlockEntity() ? WorldUtils.getTileEntity(blockGetter, pos) : null);
    }

    protected float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @Nullable BlockEntity tile) {
        ITileRadioactive radioactiveTile;
        Level level;
        Level level2 = level = tile == null ? null : tile.getLevel();
        if (level == null && blockGetter instanceof Level) {
            level = (Level)blockGetter;
        }
        if (level != null && !IBlockSecurityUtils.INSTANCE.canAccess(player, level, pos, state, tile)) {
            return 0.0f;
        }
        float speed = super.getDestroyProgress(state, player, blockGetter, pos);
        if (IRadiationManager.INSTANCE.isRadiationEnabled() && tile instanceof ITileRadioactive && (radioactiveTile = (ITileRadioactive)tile).getRadiationScale() > 0.0f) {
            return speed / 5.0f;
        }
        return speed;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        ITileRadioactive radioactiveTile;
        int count;
        BlockEntity tile;
        super.animateTick(state, world, pos, random);
        if (IRadiationManager.INSTANCE.isRadiationEnabled() && (tile = WorldUtils.getTileEntity((BlockGetter)world, pos)) instanceof ITileRadioactive && (count = (radioactiveTile = (ITileRadioactive)tile).getRadiationParticleCount()) > 0) {
            count = random.nextInt(count);
            for (int i = 0; i < count; ++i) {
                double randX = (double)pos.getX() - 0.1 + random.nextDouble() * 1.2;
                double randY = (double)pos.getY() - 0.1 + random.nextDouble() * 1.2;
                double randZ = (double)pos.getZ() - 0.1 + random.nextDouble() * 1.2;
                world.addParticle((ParticleOptions)MekanismParticleTypes.RADIATION.get(), randX, randY, randZ, 0.0, 0.0, 0.0);
            }
        }
    }

    protected ItemInteractionResult genericClientActivated(ItemStack stack, BlockEntity blockEntity) {
        if (!Attribute.has(this, AttributeGui.class) && MekanismUtils.canUseAsWrench(stack)) {
            ITileRadioactive tileRadioactive;
            if (blockEntity instanceof ITileRadioactive && (tileRadioactive = (ITileRadioactive)blockEntity).getRadiationScale() > 0.0f) {
                return ItemInteractionResult.FAIL;
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

