/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import java.util.Optional;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IFluidLogType;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IStateFluidLoggable
extends BucketPickup,
LiquidBlockContainer {
    default public boolean isValidFluid(@NotNull Fluid fluid) {
        for (IFluidLogType possibleValue : this.getFluidLoggedProperty().getPossibleValues()) {
            if (possibleValue.getFluid() != fluid) continue;
            return true;
        }
        return false;
    }

    @NotNull
    default public EnumProperty<? extends IFluidLogType> getFluidLoggedProperty() {
        return BlockStateHelper.FLUID_LOGGED;
    }

    @NotNull
    default public FluidState getFluid(@NotNull BlockState state) {
        IFluidLogType fluidLogged = (IFluidLogType)((Object)state.getValue(this.getFluidLoggedProperty()));
        if (!fluidLogged.isEmpty()) {
            Fluid fluid = fluidLogged.getFluid();
            if (fluid instanceof FlowingFluid) {
                return ((FlowingFluid)fluid).getSource(false);
            }
            return fluid.defaultFluidState();
        }
        return Fluids.EMPTY.defaultFluidState();
    }

    default public int getFluidLightLevel(@NotNull BlockState state) {
        FluidState fluid = this.getFluid(state);
        if (fluid.getType() == Fluids.LAVA) {
            return 15;
        }
        return 0;
    }

    default public void updateFluids(@NotNull BlockState state, @NotNull LevelAccessor world, @NotNull BlockPos currentPos) {
        IFluidLogType fluidLogged = (IFluidLogType)((Object)state.getValue(this.getFluidLoggedProperty()));
        if (!fluidLogged.isEmpty()) {
            Fluid fluid = fluidLogged.getFluid();
            world.scheduleTick(currentPos, fluid, fluid.getTickDelay((LevelReader)world));
        }
    }

    default public boolean canPlaceLiquid(@Nullable Player player, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Fluid fluid) {
        return ((IFluidLogType)((Object)((Enum)((Object)state.getValue(this.getFluidLoggedProperty()))))).isEmpty() && this.isValidFluid(fluid);
    }

    default public BlockState setState(BlockState state, Fluid fluid) {
        return IStateFluidLoggable.setState(state, fluid, this.getFluidLoggedProperty());
    }

    private static <T extends Enum<T> & IFluidLogType> BlockState setState(BlockState state, Fluid fluid, EnumProperty<T> property) {
        for (Enum possibleValue : property.getPossibleValues()) {
            if (((IFluidLogType)((Object)possibleValue)).getFluid() != fluid) continue;
            return (BlockState)state.setValue(property, (Comparable)((Object)possibleValue));
        }
        return state;
    }

    default public boolean placeLiquid(@NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidState) {
        Fluid fluid = fluidState.getType();
        if (this.canPlaceLiquid(null, (BlockGetter)world, pos, state, fluid)) {
            if (!world.isClientSide()) {
                world.setBlock(pos, this.setState(state, fluid), 3);
                world.scheduleTick(pos, fluid, fluid.getTickDelay((LevelReader)world));
            }
            return true;
        }
        return false;
    }

    @NotNull
    default public ItemStack pickupBlock(@Nullable Player player, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Fluid fluid;
        ItemStack bucket;
        IFluidLogType fluidLogged = (IFluidLogType)((Object)state.getValue(this.getFluidLoggedProperty()));
        if (!fluidLogged.isEmpty() && !(bucket = (fluid = fluidLogged.getFluid()).getFluidType().getBucket(new FluidStack(fluid, 1000))).isEmpty()) {
            world.setBlock(pos, this.setState(state, Fluids.EMPTY), 3);
            return bucket;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    default public Optional<SoundEvent> getPickupSound() {
        return Optional.empty();
    }

    @NotNull
    default public Optional<SoundEvent> getPickupSound(BlockState state) {
        return this.getFluid(state).getType().getPickupSound();
    }
}

