/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BasicFluidTank
implements IExtendedFluidTank {
    public static final Predicate<@NotNull FluidStack> alwaysTrue = ConstantPredicates.alwaysTrue();
    public static final Predicate<@NotNull FluidStack> alwaysFalse = ConstantPredicates.alwaysFalse();
    public static final BiPredicate<@NotNull FluidStack, @NotNull AutomationType> alwaysTrueBi = ConstantPredicates.alwaysTrueBi();
    public static final BiPredicate<@NotNull FluidStack, @NotNull AutomationType> internalOnly = ConstantPredicates.internalOnly();
    public static final BiPredicate<@NotNull FluidStack, @NotNull AutomationType> notExternal = ConstantPredicates.notExternal();
    public static final BiPredicate<@NotNull FluidStack, @NotNull AutomationType> manualOnly = (fluid, automationType) -> automationType == AutomationType.MANUAL;
    protected FluidStack stored = FluidStack.EMPTY;
    private final Predicate<@NotNull FluidStack> validator;
    protected final BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract;
    protected final BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert;
    private final int capacity;
    @Nullable
    private final IContentsListener listener;

    public static BasicFluidTank create(int capacity, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return new BasicFluidTank(capacity, alwaysTrueBi, alwaysTrueBi, alwaysTrue, listener);
    }

    public static BasicFluidTank create(int capacity, Predicate<@NotNull FluidStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Fluid validity check cannot be null");
        return new BasicFluidTank(capacity, alwaysTrueBi, alwaysTrueBi, validator, listener);
    }

    public static BasicFluidTank create(int capacity, Predicate<@NotNull FluidStack> canExtract, Predicate<@NotNull FluidStack> canInsert, @Nullable IContentsListener listener) {
        return BasicFluidTank.create(capacity, canExtract, canInsert, alwaysTrue, listener);
    }

    public static BasicFluidTank input(int capacity, Predicate<@NotNull FluidStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(validator, "Fluid validity check cannot be null");
        return new BasicFluidTank(capacity, notExternal, alwaysTrueBi, validator, listener);
    }

    public static BasicFluidTank input(int capacity, Predicate<@NotNull FluidStack> canInsert, Predicate<@NotNull FluidStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Fluid validity check cannot be null");
        return new BasicFluidTank(capacity, notExternal, (stack, automationType) -> canInsert.test((FluidStack)stack), validator, listener);
    }

    public static BasicFluidTank output(int capacity, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        return new BasicFluidTank(capacity, alwaysTrueBi, internalOnly, alwaysTrue, listener);
    }

    public static BasicFluidTank create(int capacity, Predicate<@NotNull FluidStack> canExtract, Predicate<@NotNull FluidStack> canInsert, Predicate<@NotNull FluidStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Fluid validity check cannot be null");
        return new BasicFluidTank(capacity, canExtract, canInsert, validator, listener);
    }

    public static BasicFluidTank create(int capacity, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert, Predicate<@NotNull FluidStack> validator, @Nullable IContentsListener listener) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be at least zero");
        }
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Fluid validity check cannot be null");
        return new BasicFluidTank(capacity, canExtract, canInsert, validator, listener);
    }

    protected BasicFluidTank(int capacity, Predicate<@NotNull FluidStack> canExtract, Predicate<@NotNull FluidStack> canInsert, Predicate<@NotNull FluidStack> validator, @Nullable IContentsListener listener) {
        this(capacity, (FluidStack stack, AutomationType automationType) -> automationType == AutomationType.MANUAL || canExtract.test((FluidStack)stack), (FluidStack stack, AutomationType automationType) -> canInsert.test((FluidStack)stack), validator, listener);
    }

    protected BasicFluidTank(int capacity, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert, Predicate<@NotNull FluidStack> validator, @Nullable IContentsListener listener) {
        this.capacity = capacity;
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.validator = validator;
        this.listener = listener;
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @NotNull
    public FluidStack getFluid() {
        return this.stored;
    }

    @Override
    public void setStack(FluidStack stack) {
        this.setStack(stack, true);
    }

    protected int getInsertRate(@Nullable AutomationType automationType) {
        return Integer.MAX_VALUE;
    }

    protected int getExtractRate(@Nullable AutomationType automationType) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setStackUnchecked(FluidStack stack) {
        this.setStack(stack, false);
    }

    private void setStack(FluidStack stack, boolean validateStack) {
        if (stack.isEmpty()) {
            if (this.stored.isEmpty()) {
                return;
            }
            this.stored = FluidStack.EMPTY;
        } else if (!validateStack || this.isFluidValid(stack)) {
            this.stored = stack.copy();
        } else {
            throw new RuntimeException("Invalid fluid for tank: " + String.valueOf(RegistryUtils.getName(stack.getFluid())) + " " + stack.getAmount());
        }
        this.onContentsChanged();
    }

    @Override
    public FluidStack insert(@NotNull FluidStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty() || !this.isFluidValid(stack) || !this.canInsert.test(stack, automationType)) {
            return stack;
        }
        int needed = Math.min(this.getInsertRate(automationType), this.getNeeded());
        if (needed <= 0) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = this.isFluidEqual(stack))) {
            int toAdd = Math.min(stack.getAmount(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.stored.grow(toAdd);
                    this.onContentsChanged();
                } else {
                    this.setStackUnchecked(stack.copyWithAmount(toAdd));
                }
            }
            return stack.copyWithAmount(stack.getAmount() - toAdd);
        }
        return stack;
    }

    @Override
    public FluidStack extract(int amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1 || !this.canExtract.test(this.stored, automationType)) {
            return FluidStack.EMPTY;
        }
        int size = Math.min(Math.min(this.getExtractRate(automationType), this.getFluidAmount()), amount);
        FluidStack ret = this.stored.copyWithAmount(size);
        if (!ret.isEmpty() && action.execute()) {
            this.stored.shrink(ret.getAmount());
            this.onContentsChanged();
        }
        return ret;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    @Override
    public int setStackSize(int amount, Action action) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0;
        }
        int maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getFluidAmount() == amount || action.simulate()) {
            return amount;
        }
        this.stored.setAmount(amount);
        this.onContentsChanged();
        return amount;
    }

    @Override
    public int growStack(int amount, Action action) {
        int current = this.getFluidAmount();
        if (current == 0) {
            return 0;
        }
        if (amount > 0) {
            amount = Math.min(Math.min(amount, this.getNeeded()), this.getInsertRate(null));
        } else if (amount < 0) {
            amount = Math.max(amount, -this.getExtractRate(null));
        }
        int newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    @Override
    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    @Override
    public boolean isFluidEqual(FluidStack other) {
        return FluidStack.isSameFluidSameComponents((FluidStack)this.stored, (FluidStack)other);
    }

    @Override
    public int getFluidAmount() {
        return this.stored.getAmount();
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.put("stored", this.stored.save(provider));
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        NBTUtils.setFluidStackIfPresent(provider, nbt, "stored", this::setStackUnchecked);
    }
}

