/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.resolver;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.capabilities.holder.IHolder;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BasicSidedCapabilityResolver<HANDLER, SIDED_HANDLER extends HANDLER>
implements ICapabilityResolver<Direction> {
    private final ProxyCreator<HANDLER, SIDED_HANDLER> proxyCreator;
    private final Map<Direction, HANDLER> handlers;
    private final List<BlockCapability<?, @Nullable Direction>> supportedCapability;
    private final SIDED_HANDLER baseHandler;
    @Nullable
    private HANDLER readOnlyHandler;

    public BasicSidedCapabilityResolver(SIDED_HANDLER baseHandler, BlockCapability<HANDLER, @Nullable Direction> supportedCapability, BasicProxyCreator<HANDLER, SIDED_HANDLER> proxyCreator) {
        this(baseHandler, supportedCapability, proxyCreator, true);
    }

    protected BasicSidedCapabilityResolver(SIDED_HANDLER baseHandler, BlockCapability<HANDLER, @Nullable Direction> supportedCapability, ProxyCreator<HANDLER, SIDED_HANDLER> proxyCreator, boolean canHandle) {
        this.supportedCapability = Collections.singletonList(supportedCapability);
        this.baseHandler = baseHandler;
        this.proxyCreator = proxyCreator;
        this.handlers = canHandle ? new EnumMap<Direction, HANDLER>(Direction.class) : Collections.emptyMap();
    }

    public SIDED_HANDLER getInternal() {
        return this.baseHandler;
    }

    @Override
    public List<BlockCapability<?, @Nullable Direction>> getSupportedCapabilities() {
        return this.supportedCapability;
    }

    @Nullable
    protected IHolder getHolder() {
        return null;
    }

    @Override
    @Nullable
    public <T> T resolve(BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side) {
        if (side == null) {
            if (this.readOnlyHandler == null) {
                this.readOnlyHandler = this.proxyCreator.create(this.baseHandler, null, this.getHolder());
            }
            return (T)this.readOnlyHandler;
        }
        HANDLER handler = this.handlers.get(side);
        if (handler == null) {
            handler = this.proxyCreator.create(this.baseHandler, side, this.getHolder());
            this.handlers.put(side, handler);
        }
        return (T)handler;
    }

    @Override
    public void invalidate(BlockCapability<?, @Nullable Direction> capability, @Nullable Direction side) {
        if (side == null) {
            this.readOnlyHandler = null;
        } else {
            this.handlers.remove(side);
        }
    }

    @Override
    public void invalidateAll() {
        this.readOnlyHandler = null;
        this.handlers.clear();
    }

    @FunctionalInterface
    public static interface ProxyCreator<HANDLER, SIDED_HANDLER extends HANDLER> {
        public HANDLER create(SIDED_HANDLER var1, @Nullable Direction var2, @Nullable IHolder var3);
    }

    @FunctionalInterface
    public static interface BasicProxyCreator<HANDLER, SIDED_HANDLER extends HANDLER>
    extends ProxyCreator<HANDLER, SIDED_HANDLER> {
        public HANDLER create(SIDED_HANDLER var1, @Nullable Direction var2);

        @Override
        default public HANDLER create(SIDED_HANDLER handler, @Nullable Direction side, @Nullable IHolder holder) {
            return this.create(handler, side);
        }
    }
}

