/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.radiation.capability.IRadiationEntity;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RadiationCommand {
    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"radiation").requires((Predicate)MekanismPermissions.COMMAND_RADIATION)).then(RadiationCommand.subCommandAdd())).then(RadiationCommand.subCommandAddEntity())).then(RadiationCommand.subCommandGet())).then(RadiationCommand.subCommandHeal())).then(RadiationCommand.subCommandReduce())).then(((LiteralArgumentBuilder)Commands.literal((String)"removeAll").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_REMOVE_ALL)).executes(ctx -> {
            RadiationManager.get().clearSources();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> MekanismLang.COMMAND_RADIATION_REMOVE_ALL.translateColored(EnumColor.GRAY), true);
            return 0;
        }));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandAdd() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"add").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_ADD)).then(((RequiredArgumentBuilder)Commands.argument((String)"magnitude", (ArgumentType)DoubleArgumentType.doubleArg((double)Double.MIN_VALUE, (double)10000.0)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.addRadiation(source, source.getPosition(), (Level)source.getLevel(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude"));
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.addRadiation(source, Vec3Argument.getCoordinates((CommandContext)ctx, (String)"location"), (Level)source.getLevel(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude"));
        })).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.addRadiation(source, Vec3Argument.getCoordinates((CommandContext)ctx, (String)"location"), (Level)DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude"));
        }))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandAddEntity() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addEntity").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_ADD_ENTITY)).then(Commands.argument((String)"magnitude", (ArgumentType)DoubleArgumentType.doubleArg((double)Double.MIN_VALUE, (double)10000.0)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            double magnitude = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude");
            IRadiationEntity cap = (IRadiationEntity)source.getPlayerOrException().getCapability(Capabilities.RADIATION_ENTITY);
            if (cap != null) {
                cap.radiate(magnitude);
                source.sendSuccess(() -> MekanismLang.COMMAND_RADIATION_ADD_ENTITY.translateColored(EnumColor.GRAY, RadiationManager.RadiationScale.getSeverityColor(magnitude), UnitDisplayUtils.getDisplayShort(magnitude, UnitDisplayUtils.RadiationUnit.SVH, 3)), true);
            }
            return 0;
        }))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).requires((Predicate)MekanismPermissions.COMMAND_RADIATION_ADD_ENTITY_OTHERS)).then(Commands.argument((String)"magnitude", (ArgumentType)DoubleArgumentType.doubleArg((double)Double.MIN_VALUE, (double)10000.0)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            double magnitude = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude");
            int addedTo = 0;
            for (Entity entity : EntityArgument.getEntities((CommandContext)ctx, (String)"targets")) {
                if (!(entity instanceof LivingEntity)) continue;
                IRadiationEntity cap = (IRadiationEntity)entity.getCapability(Capabilities.RADIATION_ENTITY);
                if (cap != null) {
                    cap.radiate(magnitude);
                    source.sendSuccess(() -> MekanismLang.COMMAND_RADIATION_ADD_ENTITY_TARGET.translateColored(EnumColor.GRAY, RadiationManager.RadiationScale.getSeverityColor(magnitude), UnitDisplayUtils.getDisplayShort(magnitude, UnitDisplayUtils.RadiationUnit.SVH, 3), EnumColor.INDIGO, entity.getDisplayName()), true);
                }
                ++addedTo;
            }
            return addedTo;
        })));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandGet() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_GET)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.getRadiationLevel(source, source.getPosition(), (Level)source.getLevel());
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.getRadiationLevel(source, Vec3Argument.getCoordinates((CommandContext)ctx, (String)"location"), (Level)source.getLevel());
        })).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> RadiationCommand.getRadiationLevel((CommandSourceStack)ctx.getSource(), Vec3Argument.getCoordinates((CommandContext)ctx, (String)"location"), (Level)DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandHeal() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"heal").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_HEAL)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            IRadiationEntity cap = (IRadiationEntity)source.getPlayerOrException().getCapability(Capabilities.RADIATION_ENTITY);
            if (cap != null) {
                cap.set(1.0E-7);
                source.sendSuccess(() -> MekanismLang.COMMAND_RADIATION_CLEAR.translateColored(EnumColor.GRAY), true);
            }
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).requires((Predicate)MekanismPermissions.COMMAND_RADIATION_HEAL_OTHERS)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            int healed = 0;
            for (Entity entity : EntityArgument.getEntities((CommandContext)ctx, (String)"targets")) {
                if (!(entity instanceof LivingEntity)) continue;
                IRadiationEntity cap = (IRadiationEntity)entity.getCapability(Capabilities.RADIATION_ENTITY);
                if (cap != null) {
                    cap.set(1.0E-7);
                    source.sendSuccess(() -> MekanismLang.COMMAND_RADIATION_CLEAR_ENTITY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, entity.getDisplayName()), true);
                }
                ++healed;
            }
            return healed;
        }));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandReduce() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reduce").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_REDUCE)).then(Commands.argument((String)"magnitude", (ArgumentType)DoubleArgumentType.doubleArg((double)Double.MIN_VALUE, (double)10000.0)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            double magnitude = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude");
            IRadiationEntity cap = (IRadiationEntity)source.getPlayerOrException().getCapability(Capabilities.RADIATION_ENTITY);
            if (cap != null) {
                double radiation = cap.getRadiation();
                double newValue = Math.max(1.0E-7, radiation - magnitude);
                double reduced = radiation - newValue;
                cap.set(newValue);
                source.sendSuccess(() -> MekanismLang.COMMAND_RADIATION_REDUCE.translateColored(EnumColor.GRAY, RadiationManager.RadiationScale.getSeverityColor(reduced), UnitDisplayUtils.getDisplayShort(reduced, UnitDisplayUtils.RadiationUnit.SVH, 3)), true);
            }
            return 0;
        }))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).requires((Predicate)MekanismPermissions.COMMAND_RADIATION_REDUCE_OTHERS)).then(Commands.argument((String)"magnitude", (ArgumentType)DoubleArgumentType.doubleArg((double)Double.MIN_VALUE, (double)10000.0)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            double magnitude = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude");
            int reducedFrom = 0;
            for (Entity entity : EntityArgument.getEntities((CommandContext)ctx, (String)"targets")) {
                if (!(entity instanceof LivingEntity)) continue;
                IRadiationEntity cap = (IRadiationEntity)entity.getCapability(Capabilities.RADIATION_ENTITY);
                if (cap != null) {
                    double radiation = cap.getRadiation();
                    double newValue = Math.max(1.0E-7, radiation - magnitude);
                    double reduced = radiation - newValue;
                    cap.set(newValue);
                    source.sendSuccess(() -> MekanismLang.COMMAND_RADIATION_REDUCE_TARGET.translateColored(EnumColor.GRAY, EnumColor.INDIGO, entity.getDisplayName(), RadiationManager.RadiationScale.getSeverityColor(reduced), UnitDisplayUtils.getDisplayShort(reduced, UnitDisplayUtils.RadiationUnit.SVH, 3)), true);
                }
                ++reducedFrom;
            }
            return reducedFrom;
        })));
    }

    private static int addRadiation(CommandSourceStack source, Coordinates location, Level world, double magnitude) {
        return RadiationCommand.addRadiation(source, location.getPosition(source), world, magnitude);
    }

    private static int addRadiation(CommandSourceStack source, Vec3 pos, Level world, double magnitude) {
        GlobalPos location = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)BlockPos.containing((Position)pos));
        IRadiationManager.INSTANCE.radiate(location, magnitude);
        source.sendSuccess(() -> MekanismLang.COMMAND_RADIATION_ADD.translateColored(EnumColor.GRAY, RadiationManager.RadiationScale.getSeverityColor(magnitude), UnitDisplayUtils.getDisplayShort(magnitude, UnitDisplayUtils.RadiationUnit.SVH, 3), EnumColor.INDIGO, RadiationCommand.getPosition(location.pos()), EnumColor.INDIGO, location.dimension().location()), true);
        return 0;
    }

    private static int getRadiationLevel(CommandSourceStack source, Coordinates location, Level world) {
        return RadiationCommand.getRadiationLevel(source, location.getPosition(source), world);
    }

    private static int getRadiationLevel(CommandSourceStack source, Vec3 pos, Level world) {
        GlobalPos location = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)BlockPos.containing((Position)pos));
        double magnitude = IRadiationManager.INSTANCE.getRadiationLevel(location);
        source.sendSuccess(() -> MekanismLang.COMMAND_RADIATION_GET.translateColored(EnumColor.GRAY, EnumColor.INDIGO, RadiationCommand.getPosition(location.pos()), EnumColor.INDIGO, location.dimension().location(), RadiationManager.RadiationScale.getSeverityColor(magnitude), UnitDisplayUtils.getDisplayShort(magnitude, UnitDisplayUtils.RadiationUnit.SVH, 3)), true);
        return 0;
    }

    private static Component getPosition(BlockPos pos) {
        return MekanismLang.GENERIC_BLOCK_POS.translate(pos.getX(), pos.getY(), pos.getZ());
    }
}

