/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command.builders;

import java.util.function.Consumer;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class StructureBuilder {
    protected final int sizeX;
    protected final int sizeY;
    protected final int sizeZ;

    protected StructureBuilder(int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    protected abstract void build(Level var1, BlockPos var2, boolean var3);

    protected void buildFrame(Level world, BlockPos start) {
        this.buildPartialFrame(world, start, -1);
    }

    protected void buildPartialFrame(Level world, BlockPos start, int cutoff) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockState casingState = this.getCasing().defaultBlockState();
        for (int x = 0; x < this.sizeX; ++x) {
            if (x <= cutoff || x >= this.sizeX - 1 - cutoff) continue;
            mutablePos.setWithOffset((Vec3i)start, x, 0, 0);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
            mutablePos.setWithOffset((Vec3i)start, x, this.sizeY - 1, 0);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
            mutablePos.setWithOffset((Vec3i)start, x, 0, this.sizeZ - 1);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
            mutablePos.setWithOffset((Vec3i)start, x, this.sizeY - 1, this.sizeZ - 1);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
        }
        for (int y = 0; y < this.sizeY; ++y) {
            if (y <= cutoff || y >= this.sizeY - 1 - cutoff) continue;
            mutablePos.setWithOffset((Vec3i)start, 0, y, 0);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
            mutablePos.setWithOffset((Vec3i)start, this.sizeX - 1, y, 0);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
            mutablePos.setWithOffset((Vec3i)start, 0, y, this.sizeZ - 1);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
            mutablePos.setWithOffset((Vec3i)start, this.sizeX - 1, y, this.sizeZ - 1);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
        }
        for (int z = 0; z < this.sizeZ; ++z) {
            if (z <= cutoff || z >= this.sizeZ - 1 - cutoff) continue;
            mutablePos.setWithOffset((Vec3i)start, 0, 0, z);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
            mutablePos.setWithOffset((Vec3i)start, this.sizeX - 1, 0, z);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
            mutablePos.setWithOffset((Vec3i)start, 0, this.sizeY - 1, z);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
            mutablePos.setWithOffset((Vec3i)start, this.sizeX - 1, this.sizeY - 1, z);
            world.setBlockAndUpdate((BlockPos)mutablePos, casingState);
        }
    }

    protected void buildWalls(Level world, BlockPos start) {
        int z;
        BlockPos.MutableBlockPos mutableStart = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = 1; x < this.sizeX - 1; ++x) {
            for (z = 1; z < this.sizeZ - 1; ++z) {
                mutablePos.set(x, 0, z);
                mutableStart.setWithOffset((Vec3i)start, (Vec3i)mutablePos);
                world.setBlockAndUpdate((BlockPos)mutableStart, this.getFloorBlock((BlockPos)mutablePos).defaultBlockState());
                mutablePos.set(x, this.sizeY - 1, z);
                mutableStart.setWithOffset((Vec3i)start, (Vec3i)mutablePos);
                world.setBlockAndUpdate((BlockPos)mutableStart, this.getRoofBlock((BlockPos)mutablePos).defaultBlockState());
            }
        }
        for (int y = 1; y < this.sizeY - 1; ++y) {
            for (int x = 1; x < this.sizeZ - 1; ++x) {
                mutablePos.set(x, y, 0);
                mutableStart.setWithOffset((Vec3i)start, (Vec3i)mutablePos);
                world.setBlockAndUpdate((BlockPos)mutableStart, this.getWallBlock((BlockPos)mutablePos).defaultBlockState());
                mutablePos.set(x, y, this.sizeZ - 1);
                mutableStart.setWithOffset((Vec3i)start, (Vec3i)mutablePos);
                world.setBlockAndUpdate((BlockPos)mutableStart, this.getWallBlock((BlockPos)mutablePos).defaultBlockState());
            }
            for (z = 1; z < this.sizeZ - 1; ++z) {
                mutablePos.set(0, y, z);
                mutableStart.setWithOffset((Vec3i)start, (Vec3i)mutablePos);
                world.setBlockAndUpdate((BlockPos)mutableStart, this.getWallBlock((BlockPos)mutablePos).defaultBlockState());
                mutablePos.set(this.sizeZ - 1, y, z);
                mutableStart.setWithOffset((Vec3i)start, (Vec3i)mutablePos);
                world.setBlockAndUpdate((BlockPos)mutableStart, this.getWallBlock((BlockPos)mutablePos).defaultBlockState());
            }
        }
    }

    protected void buildInteriorLayers(Level world, BlockPos start, int yMin, int yMax, Block block) {
        for (int y = yMin; y <= yMax; ++y) {
            this.buildInteriorLayer(world, start, y, block);
        }
    }

    protected void buildInteriorLayer(Level world, BlockPos start, int yLevel, Block block) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = 1; x < this.sizeX - 1; ++x) {
            for (int z = 1; z < this.sizeZ - 1; ++z) {
                mutablePos.setWithOffset((Vec3i)start, x, yLevel, z);
                world.setBlockAndUpdate((BlockPos)mutablePos, block.defaultBlockState());
            }
        }
    }

    protected void buildPlane(Level world, BlockPos start, int x1, int z1, int x2, int z2, int yLevel, Block block) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = x1; x < x2 - 1; ++x) {
            for (int z = z1; z < z2 - 1; ++z) {
                mutablePos.setWithOffset((Vec3i)start, x, yLevel, z);
                world.setBlockAndUpdate((BlockPos)mutablePos, block.defaultBlockState());
            }
        }
    }

    protected void buildColumn(Level world, BlockPos start, BlockPos pos, int height, Block block) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < height; ++y) {
            mutablePos.setWithOffset((Vec3i)start, pos.getX(), pos.getY() + y, pos.getZ());
            world.setBlockAndUpdate((BlockPos)mutablePos, block.defaultBlockState());
        }
    }

    protected <T extends BlockEntity> void buildColumn(Level world, BlockPos start, BlockPos pos, int height, Block block, Class<T> tileClass, Consumer<T> tileConsumer) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < height; ++y) {
            mutablePos.setWithOffset((Vec3i)start, pos.getX(), pos.getY() + y, pos.getZ());
            world.setBlockAndUpdate((BlockPos)mutablePos, block.defaultBlockState());
            T tile = WorldUtils.getTileEntity(tileClass, (BlockGetter)world, (BlockPos)mutablePos);
            if (tile == null) continue;
            tileConsumer.accept(tile);
        }
    }

    protected Block getWallBlock(BlockPos pos) {
        return MekanismBlocks.STRUCTURAL_GLASS.getBlock();
    }

    protected Block getFloorBlock(BlockPos pos) {
        return this.getCasing();
    }

    protected Block getRoofBlock(BlockPos pos) {
        return this.getWallBlock(pos);
    }

    protected abstract Block getCasing();
}

