/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.value.CachedLongValue;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class StorageConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final CachedLongValue enrichmentChamber;
    public final CachedLongValue osmiumCompressor;
    public final CachedLongValue combiner;
    public final CachedLongValue crusher;
    public final CachedLongValue metallurgicInfuser;
    public final CachedLongValue purificationChamber;
    public final CachedLongValue energizedSmelter;
    public final CachedLongValue digitalMiner;
    public final CachedLongValue electricPump;
    public final CachedLongValue chargePad;
    public final CachedLongValue rotaryCondensentrator;
    public final CachedLongValue chemicalOxidizer;
    public final CachedLongValue chemicalInfuser;
    public final CachedLongValue chemicalInjectionChamber;
    public final CachedLongValue electrolyticSeparator;
    public final CachedLongValue precisionSawmill;
    public final CachedLongValue chemicalDissolutionChamber;
    public final CachedLongValue chemicalWasher;
    public final CachedLongValue chemicalCrystallizer;
    public final CachedLongValue seismicVibrator;
    public final CachedLongValue pressurizedReactionBase;
    public final CachedLongValue fluidicPlenisher;
    public final CachedLongValue laser;
    public final CachedLongValue laserAmplifier;
    public final CachedLongValue laserTractorBeam;
    public final CachedLongValue formulaicAssemblicator;
    public final CachedLongValue teleporter;
    public final CachedLongValue modificationStation;
    public final CachedLongValue isotopicCentrifuge;
    public final CachedLongValue nutritionalLiquifier;
    public final CachedLongValue antiprotonicNucleosynthesizer;
    public final CachedLongValue pigmentExtractor;
    public final CachedLongValue pigmentMixer;
    public final CachedLongValue paintingMachine;
    public final CachedLongValue spsPort;
    public final CachedLongValue dimensionalStabilizer;

    StorageConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("Machine Energy Storage Config. This config is synced from server to client.").push("storage");
        this.enrichmentChamber = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "enrichmentChamber", 20000L, 1L);
        this.osmiumCompressor = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "osmiumCompressor", 80000L, 1L);
        this.combiner = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "combiner", 40000L, 1L);
        this.crusher = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "crusher", 20000L, 1L);
        this.metallurgicInfuser = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "metallurgicInfuser", 20000L, 1L);
        this.purificationChamber = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "purificationChamber", 80000L, 1L);
        this.energizedSmelter = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "energizedSmelter", 20000L, 1L);
        this.digitalMiner = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "digitalMiner", 50000L, 1L);
        this.electricPump = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "electricPump", 40000L, 1L);
        this.chargePad = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "chargePad", 2048000L, 1L);
        this.rotaryCondensentrator = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "rotaryCondensentrator", 20000L, 1L);
        this.chemicalOxidizer = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "chemicalOxidizer", 80000L, 1L);
        this.chemicalInfuser = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "chemicalInfuser", 80000L, 1L);
        this.chemicalInjectionChamber = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "chemicalInjectionChamber", 160000L, 1L);
        this.electrolyticSeparator = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "electrolyticSeparator", 160000L, 1L);
        this.precisionSawmill = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "precisionSawmill", 20000L, 1L);
        this.chemicalDissolutionChamber = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "chemicalDissolutionChamber", 160000L, 1L);
        this.chemicalWasher = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "chemicalWasher", 80000L, 1L);
        this.chemicalCrystallizer = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "chemicalCrystallizer", 160000L, 1L);
        this.seismicVibrator = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "seismicVibrator", 20000L, 1L);
        this.pressurizedReactionBase = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "pressurizedReactionBase", 2000L, 1L);
        this.fluidicPlenisher = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "fluidicPlenisher", 40000L, 1L);
        this.laser = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "laser", 2000000L, 1L);
        this.laserAmplifier = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "laserAmplifier", 5000000000L, 1L);
        this.laserTractorBeam = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "laserTractorBeam", 5000000000L, 1L);
        this.formulaicAssemblicator = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "formulaicAssemblicator", 40000L, 1L);
        this.teleporter = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "teleporter", 5000000L, 1L);
        this.modificationStation = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "modificationStation", 40000L, 1L);
        this.isotopicCentrifuge = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "isotopicCentrifuge", 80000L, 1L);
        this.nutritionalLiquifier = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "nutritionalLiquifier", 40000L, 1L);
        this.antiprotonicNucleosynthesizer = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules). Also defines max process rate.", "antiprotonicNucleosynthesizer", 1000000000L, 1L);
        this.pigmentExtractor = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "pigmentExtractor", 40000L, 1L);
        this.pigmentMixer = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "pigmentMixer", 80000L, 1L);
        this.paintingMachine = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "paintingMachine", 40000L, 1L);
        this.spsPort = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules). Also defines max output rate.", "spsPort", 1000000000L, 1L);
        this.dimensionalStabilizer = CachedLongValue.definedMin(this, builder, "Base energy storage (Joules).", "dimensionalStabilizer", 40000L, 1L);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "machine-storage";
    }

    @Override
    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

