/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import mekanism.api.functions.FloatSupplier;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.resource.ore.BaseOreConfig;
import mekanism.common.resource.ore.OreType;
import mekanism.common.util.EnumUtils;
import mekanism.common.world.height.ConfigurableHeightRange;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class WorldConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final CachedBooleanValue enableRegeneration;
    public final CachedIntValue userGenVersion;
    private final Map<OreType, OreConfig> ores = new EnumMap<OreType, OreConfig>(OreType.class);
    public final SaltConfig salt;

    WorldConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.comment("World generation settings for Mekanism. This config is synced from server to client").push("world_generation");
        this.enableRegeneration = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)builder.comment("Allows chunks to retrogen Mekanism ore blocks.").define("enableRegeneration", false));
        this.userGenVersion = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Change this value to cause Mekanism to regen its ore in all loaded chunks.").defineInRange("userWorldGenVersion", 0, 0, Integer.MAX_VALUE));
        for (OreType ore : EnumUtils.ORE_TYPES) {
            this.ores.put(ore, new OreConfig(this, builder, ore));
        }
        this.salt = new SaltConfig(this, builder, 2, 2, 3, 1);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "world";
    }

    @Override
    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public OreVeinConfig getVeinConfig(OreType.OreVeinType oreVeinType) {
        return this.ores.get((Object)((Object)oreVeinType.type())).veinConfigs.get(oreVeinType.index());
    }

    private static class OreConfig {
        private final CachedBooleanValue shouldGenerate;
        private final List<OreVeinConfig> veinConfigs;

        private OreConfig(IMekanismConfig config, ModConfigSpec.Builder builder, OreType oreType) {
            String ore = oreType.getResource().getRegistrySuffix();
            builder.comment("Generation Settings for " + ore + " ore.").push(ore);
            this.shouldGenerate = CachedBooleanValue.wrap(config, (ModConfigSpec.ConfigValue<Boolean>)builder.comment("Determines if " + ore + " ore should be added to world generation.").define("shouldGenerate", true));
            ImmutableList.Builder veinBuilder = ImmutableList.builder();
            for (BaseOreConfig baseConfig : oreType.getBaseConfigs()) {
                String veinType = baseConfig.name() + " " + ore + " vein";
                builder.comment(veinType + " Generation Settings.").push(baseConfig.name());
                CachedBooleanValue shouldVeinTypeGenerate = CachedBooleanValue.wrap(config, (ModConfigSpec.ConfigValue<Boolean>)builder.comment("Determines if " + veinType + "s should be added to world generation. Note: Requires generating " + ore + " ore to be enabled.").define("shouldGenerate", true));
                veinBuilder.add((Object)new OreVeinConfig(() -> this.shouldGenerate.get() && shouldVeinTypeGenerate.get(), CachedIntValue.wrap(config, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Chance that " + veinType + "s generates in a chunk.").defineInRange("perChunk", baseConfig.perChunk(), 1, 256)), CachedIntValue.wrap(config, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Maximum number of blocks in a " + veinType + ".").defineInRange("maxVeinSize", baseConfig.maxVeinSize(), 1, 64)), CachedFloatValue.wrap(config, (ModConfigSpec.ConfigValue<Double>)builder.comment("Chance that blocks that are directly exposed to air in a " + veinType + " are not placed.").defineInRange("discardChanceOnAirExposure", (double)baseConfig.discardChanceOnAirExposure(), 0.0, 1.0)), ConfigurableHeightRange.create(config, builder, veinType, baseConfig)));
                builder.pop();
            }
            this.veinConfigs = veinBuilder.build();
            builder.pop();
        }
    }

    public static class SaltConfig {
        public final CachedBooleanValue shouldGenerate;
        public final CachedIntValue perChunk;
        public final CachedIntValue minRadius;
        public final CachedIntValue maxRadius;
        public final CachedIntValue halfHeight;

        private SaltConfig(IMekanismConfig config, ModConfigSpec.Builder builder, int perChunk, int baseRadius, int spread, int ySize) {
            builder.comment("Generation Settings for salt.").push("salt");
            this.shouldGenerate = CachedBooleanValue.wrap(config, (ModConfigSpec.ConfigValue<Boolean>)builder.comment("Determines if salt should be added to world generation.").define("shouldGenerate", true));
            this.perChunk = CachedIntValue.wrap(config, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Chance that salt generates in a chunk.").defineInRange("perChunk", perChunk, 1, 256));
            this.minRadius = CachedIntValue.wrap(config, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Base radius of a vein of salt.").defineInRange("minRadius", baseRadius, 1, 4));
            this.maxRadius = CachedIntValue.wrap(config, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Extended variability (spread) for the radius in a vein of salt.").define("maxRadius", (Object)spread, o -> {
                Integer value;
                if (o instanceof Integer && (value = (Integer)o) >= 1 && value <= 4) {
                    return value >= this.minRadius.getOrDefault();
                }
                return false;
            }));
            this.halfHeight = CachedIntValue.wrap(config, (ModConfigSpec.ConfigValue<Integer>)builder.comment("Number of blocks to extend up and down when placing a vein of salt.").defineInRange("halfHeight", ySize, 0, (DimensionType.MAX_Y - DimensionType.MIN_Y - 1) / 2));
            builder.pop();
        }
    }

    public record OreVeinConfig(BooleanSupplier shouldGenerate, CachedIntValue perChunk, IntSupplier maxVeinSize, FloatSupplier discardChanceOnAirExposure, ConfigurableHeightRange range) {
    }
}

