/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.function.LongSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedValue;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CachedLongValue
extends CachedValue<Long>
implements LongSupplier {
    private boolean resolved;
    private long cachedValue;

    private CachedLongValue(IMekanismConfig config, ModConfigSpec.ConfigValue<Long> internal) {
        super(config, internal);
    }

    public static CachedLongValue wrap(IMekanismConfig config, ModConfigSpec.ConfigValue<Long> internal) {
        return new CachedLongValue(config, internal);
    }

    public static CachedLongValue definePositive(IMekanismConfig config, ModConfigSpec.Builder builder, String comment, String path, long defaultValue) {
        return CachedLongValue.define(config, builder, comment, path, defaultValue, 0L, Long.MAX_VALUE);
    }

    public static CachedLongValue definedMin(IMekanismConfig config, ModConfigSpec.Builder builder, String comment, String path, long defaultValue, long min) {
        return CachedLongValue.define(config, builder, comment, path, defaultValue, min, Long.MAX_VALUE);
    }

    public static CachedLongValue define(IMekanismConfig config, ModConfigSpec.Builder builder, String comment, String path, long defaultValue, long min, long max) {
        return CachedLongValue.wrap(config, (ModConfigSpec.ConfigValue<Long>)builder.comment(comment).defineInRange(path, defaultValue, min, max));
    }

    public long getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return (Long)this.internal.getDefault();
    }

    public long get() {
        if (!this.resolved) {
            this.cachedValue = (Long)this.internal.get();
            this.resolved = true;
        }
        return this.cachedValue;
    }

    @Override
    public long getAsLong() {
        return this.get();
    }

    public void set(long value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        long oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

