/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.entangloporter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.RelativeSide;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.distribution.ChemicalHandlerTarget;
import mekanism.common.content.network.distribution.EnergyAcceptorTarget;
import mekanism.common.content.network.distribution.FluidHandlerTarget;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EntangloporterInventorySlot;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryFrequency
extends Frequency
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler,
IGasTracker,
IInfusionTracker,
IPigmentTracker,
ISlurryTracker {
    public static final Codec<InventoryFrequency> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("name").forGetter(Frequency::getName), (App)UUIDUtil.CODEC.optionalFieldOf("owner").forGetter(freq -> Optional.ofNullable(freq.getOwner())), (App)SecurityMode.CODEC.fieldOf("security_mode").forGetter(Frequency::getSecurity), (App)SerializerHelper.POSITIVE_LONG_CODEC_LEGACY.fieldOf("energy").forGetter(freq -> freq.storedEnergy.getEnergy()), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid").forGetter(freq -> freq.storedFluid.getFluid()), (App)GasStack.OPTIONAL_CODEC.fieldOf("gas").forGetter(freq -> (GasStack)freq.storedGas.getStack()), (App)InfusionStack.OPTIONAL_CODEC.fieldOf("infuse_type").forGetter(freq -> (InfusionStack)freq.storedInfusion.getStack()), (App)PigmentStack.OPTIONAL_CODEC.fieldOf("pigment").forGetter(freq -> (PigmentStack)freq.storedPigment.getStack()), (App)SlurryStack.OPTIONAL_CODEC.fieldOf("slurry").forGetter(freq -> (SlurryStack)freq.storedSlurry.getStack()), (App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(freq -> freq.storedItem.getStack()), (App)Codec.DOUBLE.fieldOf("heat").forGetter(freq -> freq.storedHeat.getHeat()), (App)Codec.DOUBLE.fieldOf("heat_capacity").forGetter(freq -> freq.storedHeat.getHeatCapacity())).apply((Applicative)instance, (name, owner, securityMode, energy, fluid, gas, infusion, pigment, slurry, item, heat, heatCapacity) -> {
        InventoryFrequency frequency = new InventoryFrequency((String)name, owner.orElse(null), (SecurityMode)securityMode);
        frequency.storedEnergy.setEnergy((long)energy);
        frequency.storedFluid.setStackUnchecked((FluidStack)fluid);
        frequency.storedGas.setStackUnchecked(gas);
        frequency.storedInfusion.setStackUnchecked(infusion);
        frequency.storedPigment.setStackUnchecked(pigment);
        frequency.storedSlurry.setStackUnchecked(slurry);
        frequency.storedItem.setStackUnchecked((ItemStack)item);
        frequency.storedHeat.setHeat((double)heat);
        frequency.storedHeat.setHeatCapacity((double)heatCapacity, false);
        return frequency;
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, InventoryFrequency> STREAM_CODEC = PacketUtils.composite(InventoryFrequency.baseStreamCodec(InventoryFrequency::new), Function.identity(), ByteBufCodecs.VAR_LONG, freq -> freq.storedEnergy.getEnergy(), FluidStack.OPTIONAL_STREAM_CODEC, freq -> freq.storedFluid.getFluid(), GasStack.OPTIONAL_STREAM_CODEC, freq -> (GasStack)freq.storedGas.getStack(), InfusionStack.OPTIONAL_STREAM_CODEC, freq -> (InfusionStack)freq.storedInfusion.getStack(), PigmentStack.OPTIONAL_STREAM_CODEC, freq -> (PigmentStack)freq.storedPigment.getStack(), SlurryStack.OPTIONAL_STREAM_CODEC, freq -> (SlurryStack)freq.storedSlurry.getStack(), ItemStack.OPTIONAL_STREAM_CODEC, freq -> freq.storedItem.getStack(), ByteBufCodecs.DOUBLE, freq -> freq.storedHeat.getHeat(), (frequency, energy, fluid, gas, infusion, pigment, slurry, item, heat) -> {
        frequency.storedEnergy.setEnergy((long)energy);
        frequency.storedFluid.setStack((FluidStack)fluid);
        frequency.storedGas.setStack(gas);
        frequency.storedInfusion.setStack(infusion);
        frequency.storedPigment.setStack(pigment);
        frequency.storedSlurry.setStack(slurry);
        frequency.storedItem.setStack((ItemStack)item);
        frequency.storedHeat.setHeat((double)heat);
        return frequency;
    });
    private final Map<GlobalPos, TileEntityQuantumEntangloporter> activeQEs = new Object2ObjectOpenHashMap();
    private long lastEject = -1L;
    private BasicFluidTank storedFluid;
    private IGasTank storedGas;
    private IInfusionTank storedInfusion;
    private IPigmentTank storedPigment;
    private ISlurryTank storedSlurry;
    private BasicInventorySlot storedItem;
    public IEnergyContainer storedEnergy;
    private BasicHeatCapacitor storedHeat;
    private List<IInventorySlot> inventorySlots;
    private List<IGasTank> gasTanks;
    private List<IInfusionTank> infusionTanks;
    private List<IPigmentTank> pigmentTanks;
    private List<ISlurryTank> slurryTanks;
    private List<IExtendedFluidTank> fluidTanks;
    private List<IEnergyContainer> energyContainers;
    private List<IHeatCapacitor> heatCapacitors;

    public InventoryFrequency(String n, @Nullable UUID uuid, SecurityMode securityMode) {
        super(FrequencyType.INVENTORY, n, uuid, securityMode);
        this.presetVariables();
    }

    private InventoryFrequency(String name, @Nullable UUID owner, String ownerName, SecurityMode securityMode) {
        super(FrequencyType.INVENTORY, name, owner, ownerName, securityMode);
        this.presetVariables();
    }

    private void presetVariables() {
        this.storedFluid = BasicFluidTank.create(MekanismConfig.general.entangloporterFluidBuffer.get(), this);
        this.fluidTanks = Collections.singletonList(this.storedFluid);
        this.storedGas = ChemicalTankBuilder.GAS.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.gasTanks = Collections.singletonList(this.storedGas);
        this.storedInfusion = ChemicalTankBuilder.INFUSION.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.infusionTanks = Collections.singletonList(this.storedInfusion);
        this.storedPigment = ChemicalTankBuilder.PIGMENT.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.pigmentTanks = Collections.singletonList(this.storedPigment);
        this.storedSlurry = ChemicalTankBuilder.SLURRY.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.slurryTanks = Collections.singletonList(this.storedSlurry);
        this.storedItem = EntangloporterInventorySlot.create(this);
        this.inventorySlots = Collections.singletonList(this.storedItem);
        this.storedEnergy = BasicEnergyContainer.create(MekanismConfig.general.entangloporterEnergyBuffer.getAsLong(), this);
        this.energyContainers = Collections.singletonList(this.storedEnergy);
        this.storedHeat = BasicHeatCapacitor.create(1.0, 1.0, 1000.0, null, this);
        this.heatCapacitors = Collections.singletonList(this.storedHeat);
    }

    @Override
    @NotNull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    @NotNull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    @NotNull
    public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionTanks;
    }

    @Override
    @NotNull
    public List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.pigmentTanks;
    }

    @Override
    @NotNull
    public List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.slurryTanks;
    }

    @Override
    @NotNull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @NotNull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    @NotNull
    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
        return this.heatCapacitors;
    }

    @Override
    public void onContentsChanged() {
        this.dirty = true;
    }

    @Override
    public boolean update(BlockEntity tile) {
        boolean changedData = super.update(tile);
        if (tile instanceof TileEntityQuantumEntangloporter) {
            TileEntityQuantumEntangloporter entangloporter = (TileEntityQuantumEntangloporter)tile;
            this.activeQEs.put(entangloporter.getTileGlobalPos(), entangloporter);
        } else {
            this.activeQEs.remove(GlobalPos.of((ResourceKey)tile.getLevel().dimension(), (BlockPos)tile.getBlockPos()));
        }
        return changedData;
    }

    @Override
    public boolean onDeactivate(BlockEntity tile) {
        boolean changedData = super.onDeactivate(tile);
        this.activeQEs.remove(GlobalPos.of((ResourceKey)tile.getLevel().dimension(), (BlockPos)tile.getBlockPos()));
        return changedData;
    }

    public void handleEject(long gameTime) {
        if (this.isValid() && !this.activeQEs.isEmpty() && this.lastEject != gameTime) {
            this.lastEject = gameTime;
            EnumMap typesToEject = new EnumMap(TransmissionType.class);
            ArrayList<Runnable> transferHandlers = new ArrayList<Runnable>(EnumUtils.TRANSMISSION_TYPES.length - 2);
            int expected = 6 * this.activeQEs.size();
            this.addEnergyTransferHandler(typesToEject, transferHandlers, expected);
            this.addFluidTransferHandler(typesToEject, transferHandlers, expected);
            this.addChemicalTransferHandler(TransmissionType.GAS, this.storedGas, typesToEject, transferHandlers, expected);
            this.addChemicalTransferHandler(TransmissionType.INFUSION, this.storedInfusion, typesToEject, transferHandlers, expected);
            this.addChemicalTransferHandler(TransmissionType.PIGMENT, this.storedPigment, typesToEject, transferHandlers, expected);
            this.addChemicalTransferHandler(TransmissionType.SLURRY, this.storedSlurry, typesToEject, transferHandlers, expected);
            if (!typesToEject.isEmpty()) {
                for (TileEntityQuantumEntangloporter qe : this.activeQEs.values()) {
                    ServerLevel level;
                    if (!qe.canFunction() || (level = (ServerLevel)qe.getLevel()) == null || !level.shouldTickBlocksAt(ChunkPos.asLong((BlockPos)qe.getBlockPos()))) continue;
                    Direction facing = qe.getDirection();
                    for (Map.Entry entry : typesToEject.entrySet()) {
                        TransmissionType transmissionType = (TransmissionType)entry.getKey();
                        ConfigInfo config = qe.getConfig().getConfig(transmissionType);
                        if (config == null || !qe.getEjector().isEjecting(config, transmissionType)) continue;
                        for (Map.Entry<RelativeSide, DataType> sideEntry : config.getSideConfig()) {
                            if (!sideEntry.getValue().canOutput()) continue;
                            Direction side = sideEntry.getKey().getDirection(facing);
                            InventoryFrequency.accept((Consumer)entry.getValue(), qe, side, transmissionType);
                        }
                    }
                }
                for (Runnable transferHandler : transferHandlers) {
                    transferHandler.run();
                }
            }
        }
    }

    private static <TYPE> void accept(Consumer<TYPE> consumer, TileEntityQuantumEntangloporter qe, Direction side, TransmissionType transmissionType) {
        Object cachedCapability = qe.getCachedCapability(side, transmissionType);
        if (cachedCapability != null) {
            consumer.accept(cachedCapability);
        }
    }

    private void addEnergyTransferHandler(Map<TransmissionType, Consumer<?>> typesToEject, List<Runnable> transferHandlers, int expected) {
        long toSend = this.storedEnergy.extract(this.storedEnergy.getMaxEnergy(), Action.SIMULATE, AutomationType.INTERNAL);
        if (toSend > 0L) {
            SendingEnergyAcceptorTarget target = new SendingEnergyAcceptorTarget(expected, this.storedEnergy, toSend);
            typesToEject.put(TransmissionType.ENERGY, target);
            transferHandlers.add(target);
        }
    }

    private void addFluidTransferHandler(Map<TransmissionType, Consumer<?>> typesToEject, List<Runnable> transferHandlers, int expected) {
        FluidStack fluidToSend = this.storedFluid.extract(this.storedFluid.getCapacity(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!fluidToSend.isEmpty()) {
            SendingFluidHandlerTarget target = new SendingFluidHandlerTarget(fluidToSend, expected, this.storedFluid);
            typesToEject.put(TransmissionType.FLUID, target);
            transferHandlers.add(target);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void addChemicalTransferHandler(TransmissionType chemicalType, IChemicalTank<CHEMICAL, STACK> tank, Map<TransmissionType, Consumer<?>> typesToEject, List<Runnable> transferHandlers, int expected) {
        STACK toSend = tank.extract(tank.getCapacity(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!((ChemicalStack)toSend).isEmpty()) {
            SendingChemicalHandlerTarget target = new SendingChemicalHandlerTarget(toSend, expected, tank);
            typesToEject.put(chemicalType, target);
            transferHandlers.add(target);
        }
    }

    private static class SendingEnergyAcceptorTarget
    extends EnergyAcceptorTarget
    implements Runnable,
    Consumer<IStrictEnergyHandler> {
        private final IEnergyContainer storedEnergy;
        private final long toSend;

        public SendingEnergyAcceptorTarget(int expectedSize, IEnergyContainer storedEnergy, long toSend) {
            super(expectedSize);
            this.storedEnergy = storedEnergy;
            this.toSend = toSend;
        }

        @Override
        public void run() {
            if (this.getHandlerCount() > 0) {
                this.storedEnergy.extract(EmitUtils.sendToAcceptors(this, this.toSend, Long.valueOf(this.toSend)), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }

        @Override
        public void accept(IStrictEnergyHandler handler) {
            this.addHandler(handler);
        }
    }

    private static class SendingFluidHandlerTarget
    extends FluidHandlerTarget
    implements Runnable,
    Consumer<IFluidHandler> {
        private final IExtendedFluidTank storedFluid;

        public SendingFluidHandlerTarget(@NotNull FluidStack toSend, int expectedSize, IExtendedFluidTank storedFluid) {
            super(toSend, expectedSize);
            this.storedFluid = storedFluid;
        }

        @Override
        public void run() {
            if (this.getHandlerCount() > 0) {
                this.storedFluid.extract(EmitUtils.sendToAcceptors(this, ((FluidStack)this.extra).getAmount(), (FluidStack)this.extra), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }

        @Override
        public void accept(IFluidHandler handler) {
            if (FluidUtils.canFill(handler, (FluidStack)this.extra)) {
                this.addHandler(handler);
            }
        }
    }

    private static class SendingChemicalHandlerTarget<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>>
    extends ChemicalHandlerTarget<CHEMICAL, STACK, HANDLER>
    implements Runnable,
    Consumer<HANDLER> {
        private final IChemicalTank<CHEMICAL, STACK> storedChemical;

        public SendingChemicalHandlerTarget(@NotNull STACK toSend, int expectedSize, IChemicalTank<CHEMICAL, STACK> storedChemical) {
            super(toSend, expectedSize);
            this.storedChemical = storedChemical;
        }

        @Override
        public void run() {
            if (this.getHandlerCount() > 0) {
                this.storedChemical.extract(EmitUtils.sendToAcceptors(this, ((ChemicalStack)this.extra).getAmount(), (ChemicalStack)this.extra), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }

        @Override
        public void accept(HANDLER handler) {
            if (ChemicalUtil.canInsert(handler, (ChemicalStack)this.extra)) {
                this.addHandler(handler);
            }
        }
    }
}

