/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.filter;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.function.Supplier;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerItemStackFilter;
import mekanism.common.content.miner.MinerModIDFilter;
import mekanism.common.content.miner.MinerTagFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOModIDFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.content.transporter.SorterModIDFilter;
import mekanism.common.content.transporter.SorterTagFilter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public abstract class BaseFilter<FILTER extends BaseFilter<FILTER>>
implements IFilter<FILTER> {
    public static final Codec<IFilter<?>> GENERIC_CODEC = FilterType.CODEC.dispatch(IFilter::getFilterType, FilterType::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, IFilter<?>> GENERIC_STREAM_CODEC = FilterType.STREAM_CODEC.cast().dispatch(IFilter::getFilterType, FilterType::streamCodec);
    private boolean enabled = true;

    protected static <FILTER extends BaseFilter<FILTER>> Products.P1<RecordCodecBuilder.Mu<FILTER>, Boolean> baseCodec(RecordCodecBuilder.Instance<FILTER> instance) {
        return instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(BaseFilter::isEnabled));
    }

    protected static <FILTER extends BaseFilter<FILTER>> StreamCodec<ByteBuf, FILTER> baseStreamCodec(Supplier<FILTER> constructor) {
        return ByteBufCodecs.BOOL.map(val -> {
            BaseFilter filter = (BaseFilter)constructor.get();
            filter.setEnabled((boolean)val);
            return filter;
        }, BaseFilter::isEnabled);
    }

    protected BaseFilter() {
    }

    protected BaseFilter(boolean enabled) {
        this.enabled = enabled;
    }

    protected BaseFilter(FILTER filter) {
        this(((BaseFilter)filter).isEnabled());
    }

    @Override
    public abstract FILTER clone();

    public int hashCode() {
        return Objects.hash(new Object[]{this.getFilterType(), this.enabled});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseFilter other = (BaseFilter)o;
        return this.enabled == other.enabled;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static IFilter<?> fromType(FilterType filterType) {
        return switch (filterType) {
            default -> throw new MatchException(null, null);
            case FilterType.MINER_ITEMSTACK_FILTER -> new MinerItemStackFilter();
            case FilterType.MINER_MODID_FILTER -> new MinerModIDFilter();
            case FilterType.MINER_TAG_FILTER -> new MinerTagFilter();
            case FilterType.SORTER_ITEMSTACK_FILTER -> new SorterItemStackFilter();
            case FilterType.SORTER_MODID_FILTER -> new SorterModIDFilter();
            case FilterType.SORTER_TAG_FILTER -> new SorterTagFilter();
            case FilterType.OREDICTIONIFICATOR_ITEM_FILTER -> new OredictionificatorItemFilter();
            case FilterType.QIO_ITEMSTACK_FILTER -> new QIOItemStackFilter();
            case FilterType.QIO_MODID_FILTER -> new QIOModIDFilter();
            case FilterType.QIO_TAG_FILTER -> new QIOTagFilter();
        };
    }
}

