/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.SequencedMap;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.EnchantmentAwareModule;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.content.gear.Module;
import mekanism.common.lib.codec.SequencedCollectionCodec;
import mekanism.common.lib.collection.EmptySequencedMap;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@NothingNullByDefault
public final class ModuleContainer
extends Record
implements IModuleContainer {
    private final SequencedMap<ModuleData<?>, Module<?>> typedModules;
    private final ItemEnchantments enchantments;
    public static final ModuleContainer EMPTY = new ModuleContainer(EmptySequencedMap.emptyMap(), ItemEnchantments.EMPTY);
    public static final Codec<ModuleContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)new SequencedCollectionCodec(Module.CODEC).fieldOf("modules").forGetter(container -> container.typedModules().sequencedValues()), (App)ItemEnchantments.CODEC.fieldOf("enchantments").forGetter(ModuleContainer::enchantments)).apply((Applicative)instance, ModuleContainer::create));
    public static final StreamCodec<RegistryFriendlyByteBuf, ModuleContainer> STREAM_CODEC = StreamCodec.composite((StreamCodec)Module.STREAM_CODEC.apply(streamCodec -> ByteBufCodecs.collection(ArrayList::new, (StreamCodec)streamCodec)), container -> container.typedModules().sequencedValues(), (StreamCodec)ItemEnchantments.STREAM_CODEC, ModuleContainer::enchantments, ModuleContainer::create);

    public ModuleContainer(SequencedMap<ModuleData<?>, Module<?>> typedModules, ItemEnchantments enchantments) {
        typedModules = Collections.unmodifiableSequencedMap(typedModules);
        this.typedModules = typedModules;
        this.enchantments = enchantments;
    }

    private static ModuleContainer create(SequencedCollection<Module<?>> modules, ItemEnchantments enchantments) {
        LinkedHashMap typedModules = new LinkedHashMap(modules.size());
        for (Module module : modules) {
            typedModules.put(module.getData(), module);
        }
        return new ModuleContainer(typedModules, enchantments);
    }

    public Collection<Module<?>> modules() {
        return this.typedModules().values();
    }

    @Override
    public ItemEnchantments moduleBasedEnchantments() {
        return this.enchantments;
    }

    @Nullable
    public <MODULE extends ICustomModule<MODULE>> Module<MODULE> get(IModuleDataProvider<MODULE> typeProvider) {
        return (Module)this.typedModules.get(typeProvider.getModuleData());
    }

    @Override
    public List<IHUDElement> getHUDElements(Player player, ItemStack stack) {
        if (this.typedModules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IHUDElement> ret = new ArrayList<IHUDElement>();
        for (Module<?> module : this.modules()) {
            module.addHUDElements(player, this, stack, ret);
        }
        return ret;
    }

    @Override
    public List<Component> getHUDStrings(Player player, ItemStack stack) {
        if (this.typedModules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> ret = new ArrayList<Component>();
        for (Module<?> module : this.modules()) {
            module.addHUDStrings(player, this, stack, ret);
        }
        return ret;
    }

    @Override
    public <MODULE extends ICustomModule<MODULE>> ModuleContainer replaceModuleConfig(HolderLookup.Provider provider, ItemStack stack, IModuleDataProvider<MODULE> type, ModuleConfig<?> config) {
        return this.replaceModuleConfig(provider, stack, type.getModuleData(), config, false);
    }

    public <MODULE extends ICustomModule<MODULE>> ModuleContainer replaceModuleConfig(HolderLookup.Provider provider, ItemStack stack, ModuleData<MODULE> type, ModuleConfig<?> config, boolean fromPacket) {
        IModule module = this.get((IModuleDataProvider)type);
        if (module == null) {
            throw new IllegalArgumentException("Module container does not contain any modules of type " + String.valueOf(type.getRegistryName()));
        }
        if (config.name().equals((Object)ModuleConfig.ENABLED_KEY)) {
            if (((Module)module).isEnabled() == ((Boolean)config.get()).booleanValue()) {
                return this;
            }
            return this.toggleEnabled(provider, stack, type, (Module<MODULE>)module);
        }
        if (config.name().equals((Object)ModuleConfig.HANDLES_MODE_CHANGE_KEY)) {
            if (((Module)module).handlesModeChangeRaw() == ((Boolean)config.get()).booleanValue()) {
                return this;
            }
            if (fromPacket && ((Module)module).getConfig(ModuleConfig.HANDLES_MODE_CHANGE_KEY) == null) {
                return this;
            }
            return this.toggleHandlesModeChange(stack, type, (Module<MODULE>)module);
        }
        Module replacedModule = ((Module)module).withReplacedConfig(config, fromPacket);
        if (module == replacedModule) {
            return this;
        }
        LinkedHashMap copiedModules = new LinkedHashMap(this.typedModules);
        copiedModules.put(type, replacedModule);
        return this.updateContainer(stack, copiedModules, null);
    }

    <MODULE extends ICustomModule<MODULE>> ModuleContainer toggleEnabled(HolderLookup.Provider provider, ItemStack stack, ModuleData<MODULE> type) {
        IModule module = this.get((IModuleDataProvider)type);
        if (module == null) {
            throw new IllegalArgumentException("Module container does not contain any modules of type " + String.valueOf(type.getRegistryName()));
        }
        return this.toggleEnabled(provider, stack, type, (Module<MODULE>)module);
    }

    private <MODULE extends ICustomModule<MODULE>> ModuleContainer toggleEnabled(HolderLookup.Provider provider, ItemStack stack, ModuleData<MODULE> type, Module<MODULE> module) {
        boolean setEnabled = !module.isEnabled();
        module = module.withReplacedConfig(module.getConfigOrThrow(ModuleConfig.ENABLED_KEY).with(setEnabled));
        ItemEnchantments.Mutable adjustedEnchantments = this.updateEnchantment(provider, module, null);
        LinkedHashMap copiedModules = new LinkedHashMap(this.typedModules);
        copiedModules.put(type, module);
        if (setEnabled) {
            adjustedEnchantments = this.disableOtherExclusives(provider, type, module, copiedModules, adjustedEnchantments);
        }
        return this.updateContainer(stack, copiedModules, adjustedEnchantments);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private <MODULE extends ICustomModule<MODULE>> ItemEnchantments.Mutable disableOtherExclusives(HolderLookup.Provider provider, ModuleData<MODULE> type, Module<MODULE> module, SequencedMap<ModuleData<?>, Module<?>> copiedModules, @Nullable ItemEnchantments.Mutable adjustedEnchantments) {
        boolean handlesModeChange = module.handlesModeChange();
        int exclusiveFlags = type.getExclusiveFlags();
        if (handlesModeChange || exclusiveFlags != 0) {
            for (Module<Boolean> module2 : this.modules()) {
                void var9_12;
                ModuleData<?> otherType = module2.getData();
                if (otherType == type) continue;
                if (otherType.isExclusive(exclusiveFlags) && module2.isEnabled()) {
                    ModuleConfig<Boolean> disabledConfig = module2.getConfigOrThrow(ModuleConfig.ENABLED_KEY).with(false);
                    Module<?> module3 = module2.withReplacedConfig(disabledConfig);
                    copiedModules.put(otherType, module3);
                    adjustedEnchantments = this.updateEnchantment(provider, module3, adjustedEnchantments);
                }
                if (!handlesModeChange || !var9_12.handlesModeChange()) continue;
                ModuleConfig<Boolean> modeChangeConfig = var9_12.getConfigOrThrow(ModuleConfig.HANDLES_MODE_CHANGE_KEY).with(false);
                Module module4 = var9_12.withReplacedConfig(modeChangeConfig);
                copiedModules.put(otherType, module4);
            }
        }
        return adjustedEnchantments;
    }

    @Nullable
    private <MODULE extends ICustomModule<MODULE>> ItemEnchantments.Mutable updateEnchantment(HolderLookup.Provider provider, Module<MODULE> module, @Nullable ItemEnchantments.Mutable adjustedEnchantments) {
        MODULE MODULE = module.getCustomInstance();
        if (MODULE instanceof EnchantmentAwareModule) {
            EnchantmentAwareModule enchantmentBased = (EnchantmentAwareModule)MODULE;
            Optional enchantment = provider.holder(enchantmentBased.enchantment());
            int level = ModuleContainer.getEnchantmentLevel(module);
            if (enchantment.isPresent() && this.enchantments.getLevel((Holder)enchantment.get()) != level) {
                if (adjustedEnchantments == null) {
                    adjustedEnchantments = new ItemEnchantments.Mutable(this.enchantments);
                }
                adjustedEnchantments.set((Holder)enchantment.get(), level);
            }
        }
        return adjustedEnchantments;
    }

    private static <MODULE extends EnchantmentAwareModule<MODULE>> int getEnchantmentLevel(Module<?> module) {
        Module<?> enchantBased = module;
        return ((EnchantmentAwareModule)enchantBased.getCustomInstance()).getLevelFor(enchantBased);
    }

    private <MODULE extends ICustomModule<MODULE>> ModuleContainer toggleHandlesModeChange(ItemStack stack, ModuleData<MODULE> type, Module<MODULE> module) {
        boolean setHandles = !module.handlesModeChange();
        module = module.withReplacedConfig(module.getConfigOrThrow(ModuleConfig.HANDLES_MODE_CHANGE_KEY).with(setHandles));
        LinkedHashMap copiedModules = new LinkedHashMap(this.typedModules);
        copiedModules.put(type, module);
        if (setHandles && module.handlesModeChange()) {
            for (Module<Boolean> module2 : this.modules()) {
                ModuleData<?> otherType = module2.getData();
                if (otherType == type || !module2.handlesModeChange()) continue;
                ModuleConfig<Boolean> modeChangeConfig = module2.getConfigOrThrow(ModuleConfig.HANDLES_MODE_CHANGE_KEY).with(false);
                copiedModules.put(otherType, module2.withReplacedConfig(modeChangeConfig));
            }
        }
        return this.updateContainer(stack, copiedModules, null);
    }

    public boolean canInstall(ItemStack stack, IModuleDataProvider<?> typeProvider) {
        ModuleData<?> type = typeProvider.getModuleData();
        if (IModuleHelper.INSTANCE.supports(stack.getItem(), type)) {
            IModule module = this.get((IModuleDataProvider)type);
            return module == null || module.getInstalledCount() < type.getMaxStackSize();
        }
        return false;
    }

    public <MODULE extends ICustomModule<MODULE>> int addModule(HolderLookup.Provider provider, ItemStack stack, IModuleDataProvider<MODULE> typeProvider, int toInstall) {
        boolean wasFirst;
        ModuleData<MODULE> type = typeProvider.getModuleData();
        Module<MODULE> module = this.get((IModuleDataProvider)type);
        boolean bl = wasFirst = module == null;
        if (wasFirst) {
            toInstall = Math.min(toInstall, type.getMaxStackSize());
            module = new Module<MODULE>(type, toInstall);
        } else {
            if ((toInstall = Math.min(toInstall, type.getMaxStackSize() - module.getInstalledCount())) == 0) {
                return 0;
            }
            module = module.withReplacedInstallCount(module.getInstalledCount() + toInstall);
        }
        LinkedHashMap copiedModules = new LinkedHashMap(this.typedModules);
        copiedModules.put(type, module);
        ItemEnchantments.Mutable adjustedEnchantments = this.updateEnchantment(provider, module, null);
        adjustedEnchantments = this.disableOtherExclusives(provider, type, module, copiedModules, adjustedEnchantments);
        ModuleContainer replacedContainer = this.updateContainer(stack, copiedModules, adjustedEnchantments);
        module.getCustomInstance().onAdded(module, replacedContainer, stack, wasFirst);
        return toInstall;
    }

    public <MODULE extends ICustomModule<MODULE>> void removeModule(HolderLookup.Provider provider, ItemStack stack, IModuleDataProvider<MODULE> typeProvider, @Range(from=1L, to=0x7FFFFFFFL) int toRemove) {
        ModuleData<MODULE> type = typeProvider.getModuleData();
        Module module = this.get((IModuleDataProvider)type);
        if (module != null) {
            toRemove = Math.min(toRemove, type.getMaxStackSize());
            int installed = module.getInstalledCount() - toRemove;
            boolean wasLast = installed == 0;
            LinkedHashMap copiedModules = new LinkedHashMap(this.typedModules);
            ItemEnchantments.Mutable adjustedEnchantments = null;
            if (wasLast) {
                EnchantmentAwareModule enchantmentBased;
                Optional enchantment;
                copiedModules.remove(type);
                Object MODULE = module.getCustomInstance();
                if (MODULE instanceof EnchantmentAwareModule && (enchantment = provider.holder((enchantmentBased = (EnchantmentAwareModule)MODULE).enchantment())).isPresent() && this.enchantments.getLevel((Holder)enchantment.get()) != 0) {
                    adjustedEnchantments = new ItemEnchantments.Mutable(this.enchantments);
                    adjustedEnchantments.set((Holder)enchantment.get(), 0);
                }
            } else {
                module = module.withReplacedInstallCount(installed);
                copiedModules.put(type, module);
                adjustedEnchantments = this.updateEnchantment(provider, module, null);
            }
            ModuleContainer replacedContainer = this.updateContainer(stack, copiedModules, adjustedEnchantments);
            module.getCustomInstance().onRemoved(module, replacedContainer, stack, wasLast);
        }
    }

    private ModuleContainer updateContainer(ItemStack stack, SequencedMap<ModuleData<?>, Module<?>> copiedModules, @Nullable ItemEnchantments.Mutable adjustedEnchantments) {
        ModuleContainer replacedContainer = new ModuleContainer(copiedModules, adjustedEnchantments == null ? this.enchantments : adjustedEnchantments.toImmutable());
        stack.set(MekanismDataComponents.MODULE_CONTAINER, (Object)replacedContainer);
        return replacedContainer;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ModuleContainer.class, "typedModules;enchantments", "typedModules", "enchantments"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ModuleContainer.class, "typedModules;enchantments", "typedModules", "enchantments"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ModuleContainer.class, "typedModules;enchantments", "typedModules", "enchantments"}, this, o);
    }

    public SequencedMap<ModuleData<?>, Module<?>> typedModules() {
        return this.typedModules;
    }

    public ItemEnchantments enchantments() {
        return this.enchantments;
    }
}

