/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.MathUtils;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.content.network.distribution.EnergyAcceptorTarget;
import mekanism.common.content.network.distribution.EnergyTransmitterSaveTarget;
import mekanism.common.content.network.transmitter.UniversalCable;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyNetwork
extends DynamicBufferedNetwork<IStrictEnergyHandler, EnergyNetwork, Long, UniversalCable>
implements IMekanismStrictEnergyHandler {
    private final List<IEnergyContainer> energyContainers;
    public final VariableCapacityEnergyContainer energyContainer = VariableCapacityEnergyContainer.create(this::getCapacity, BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.alwaysTrue, (IContentsListener)this);
    private long prevTransferAmount = 0L;

    public EnergyNetwork(UUID networkID) {
        super(networkID);
        this.energyContainers = Collections.singletonList(this.energyContainer);
    }

    public EnergyNetwork(Collection<EnergyNetwork> networks) {
        this(UUID.randomUUID());
        this.adoptAllAndRegister(networks);
    }

    @Override
    protected void forceScaleUpdate() {
        this.currentScale = !this.energyContainer.isEmpty() && this.energyContainer.getMaxEnergy() != 0L ? (float)Math.min(1.0, (double)this.energyContainer.getEnergy() / (double)this.energyContainer.getMaxEnergy()) : 0.0f;
    }

    @Override
    public List<UniversalCable> adoptTransmittersAndAcceptorsFrom(EnergyNetwork net) {
        long oldCapacity = this.getCapacity();
        List<UniversalCable> transmittersToUpdate = super.adoptTransmittersAndAcceptorsFrom(net);
        long ourScale = this.currentScale == 0.0f ? 0L : (long)((float)oldCapacity * this.currentScale);
        long theirScale = net.currentScale == 0.0f ? 0L : (long)((float)net.getCapacity() * net.currentScale);
        long capacity = this.getCapacity();
        this.currentScale = (float)Math.min(1.0, capacity == 0L ? 0.0 : (double)(ourScale + theirScale) / (double)capacity);
        if (!this.isRemote() && !net.energyContainer.isEmpty()) {
            this.energyContainer.setEnergy(MathUtils.addClamped(this.energyContainer.getEnergy(), net.getBuffer()));
            net.energyContainer.setEmpty();
        }
        return transmittersToUpdate;
    }

    @Override
    @NotNull
    public Long getBuffer() {
        return this.energyContainer.getEnergy();
    }

    @Override
    public void absorbBuffer(UniversalCable transmitter) {
        long energy = transmitter.releaseShare();
        if (energy != 0L) {
            this.energyContainer.setEnergy(this.energyContainer.getEnergy() + energy);
        }
    }

    @Override
    public void clampBuffer() {
        if (!this.energyContainer.isEmpty()) {
            long capacity = this.getCapacity();
            if (this.energyContainer.getEnergy() > capacity) {
                this.energyContainer.setEnergy(capacity);
            }
        }
    }

    @Override
    protected void updateSaveShares(@Nullable UniversalCable triggerTransmitter) {
        super.updateSaveShares(triggerTransmitter);
        if (!this.isEmpty()) {
            EnergyTransmitterSaveTarget saveTarget = new EnergyTransmitterSaveTarget(this.getTransmitters());
            long energy = this.energyContainer.getEnergy();
            EmitUtils.sendToAcceptors(saveTarget, energy, Long.valueOf(energy));
            saveTarget.save();
        }
    }

    private long tickEmit(long energyToSend) {
        Collection acceptorValues = this.acceptorCache.getAcceptorValues();
        EnergyAcceptorTarget target = new EnergyAcceptorTarget(acceptorValues.size() * 2);
        for (Map acceptors : acceptorValues) {
            for (IStrictEnergyHandler acceptor : acceptors.values()) {
                if (acceptor.insertEnergy(energyToSend, Action.SIMULATE) >= energyToSend) continue;
                target.addHandler(acceptor);
            }
        }
        return EmitUtils.sendToAcceptors(target, energyToSend, Long.valueOf(energyToSend));
    }

    public String toString() {
        return "[EnergyNetwork] " + this.transmittersSize() + " transmitters, " + this.getAcceptorCount() + " acceptors.";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.needsUpdate) {
            NeoForge.EVENT_BUS.post((Event)new EnergyTransferEvent(this));
            this.needsUpdate = false;
        }
        if (this.energyContainer.isEmpty()) {
            this.prevTransferAmount = 0L;
        } else {
            this.prevTransferAmount = this.tickEmit(this.energyContainer.getEnergy());
            this.energyContainer.extract(this.prevTransferAmount, Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    @Override
    protected float computeContentScale() {
        float scale = (float)MathUtils.divideToLevel(this.energyContainer.getEnergy(), this.energyContainer.getMaxEnergy());
        float ret = Math.max(this.currentScale, scale);
        if (this.prevTransferAmount != 0L && ret < 1.0f) {
            ret = Math.min(1.0f, ret + 0.02f);
        } else if (this.prevTransferAmount == 0L && ret > 0.0f) {
            ret = Math.max(scale, ret - 0.02f);
        }
        return ret;
    }

    @Override
    public Component getNeededInfo() {
        return EnergyDisplay.of(this.energyContainer.getNeeded()).getTextComponent();
    }

    @Override
    public Component getStoredInfo() {
        return EnergyDisplay.of(this.energyContainer.getEnergy()).getTextComponent();
    }

    @Override
    public Component getFlowInfo() {
        return MekanismLang.GENERIC_PER_TICK.translate(EnergyDisplay.of(this.prevTransferAmount));
    }

    @Override
    @NotNull
    public Component getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.ENERGY_NETWORK, this.transmittersSize(), this.getAcceptorCount());
    }

    @Override
    @NotNull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    public void onContentsChanged() {
        this.markDirty();
    }

    public static class EnergyTransferEvent
    extends DynamicBufferedNetwork.TransferEvent<EnergyNetwork> {
        public EnergyTransferEvent(EnergyNetwork network) {
            super(network);
        }
    }
}

