/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.merged.BoxedChemical;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.chemical.BoxedChemicalHandler;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.CompatibleTransmitterValidator;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.BoxedChemicalAcceptorCache;
import mekanism.common.tier.TubeTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.PressurizedTubeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoxedPressurizedTube
extends BufferedTransmitter<BoxedChemicalHandler, BoxedChemicalNetwork, BoxedChemicalStack, BoxedPressurizedTube>
implements IGasTracker,
IInfusionTracker,
IPigmentTracker,
ISlurryTracker,
IUpgradeableTransmitter<PressurizedTubeUpgradeData> {
    public final TubeTier tier;
    public final MergedChemicalTank chemicalTank;
    private final List<IGasTank> gasTanks;
    private final List<IInfusionTank> infusionTanks;
    private final List<IPigmentTank> pigmentTanks;
    private final List<ISlurryTank> slurryTanks;
    @NotNull
    public BoxedChemicalStack saveShare = BoxedChemicalStack.EMPTY;

    public BoxedPressurizedTube(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(tile, TransmissionType.GAS, TransmissionType.INFUSION, TransmissionType.PIGMENT, TransmissionType.SLURRY);
        this.tier = Attribute.getTier(blockProvider, TubeTier.class);
        this.chemicalTank = MergedChemicalTank.create(ChemicalTankBuilder.GAS.createAllValid(this.getCapacity(), this), ChemicalTankBuilder.INFUSION.createAllValid(this.getCapacity(), this), ChemicalTankBuilder.PIGMENT.createAllValid(this.getCapacity(), this), ChemicalTankBuilder.SLURRY.createAllValid(this.getCapacity(), this));
        this.gasTanks = Collections.singletonList(this.chemicalTank.getGasTank());
        this.infusionTanks = Collections.singletonList(this.chemicalTank.getInfusionTank());
        this.pigmentTanks = Collections.singletonList(this.chemicalTank.getPigmentTank());
        this.slurryTanks = Collections.singletonList(this.chemicalTank.getSlurryTank());
    }

    protected BoxedChemicalAcceptorCache createAcceptorCache() {
        return new BoxedChemicalAcceptorCache(this.getTransmitterTile());
    }

    public BoxedChemicalAcceptorCache getAcceptorCache() {
        return (BoxedChemicalAcceptorCache)super.getAcceptorCache();
    }

    @Override
    public TubeTier getTier() {
        return this.tier;
    }

    @Override
    public void pullFromAcceptors() {
        Set<Direction> connections = this.getConnections(ConnectionType.PULL);
        if (!connections.isEmpty()) {
            for (BoxedChemicalHandler connectedAcceptor : this.getAcceptorCache().getConnectedAcceptors(connections)) {
                BoxedChemicalStack bufferWithFallback = this.getBufferWithFallback();
                if (bufferWithFallback.isEmpty()) {
                    for (ChemicalType chemicalType : EnumUtils.CHEMICAL_TYPES) {
                        if (this.pullFromAcceptor(connectedAcceptor, chemicalType, bufferWithFallback, true)) break;
                    }
                    continue;
                }
                this.pullFromAcceptor(connectedAcceptor, bufferWithFallback.getChemicalType(), bufferWithFallback, false);
            }
        }
    }

    private boolean pullFromAcceptor(BoxedChemicalHandler acceptor, ChemicalType chemicalType, BoxedChemicalStack bufferWithFallback, boolean bufferIsEmpty) {
        IChemicalHandler handler = acceptor.getHandlerFor(chemicalType);
        if (handler != null) {
            return this.pullFromAcceptor(handler, bufferWithFallback, chemicalType, bufferIsEmpty);
        }
        return false;
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> boolean pullFromAcceptor(HANDLER connectedAcceptor, BoxedChemicalStack bufferWithFallback, ChemicalType chemicalType, boolean bufferIsEmpty) {
        long availablePull = this.getAvailablePull(chemicalType);
        Object received = bufferIsEmpty ? connectedAcceptor.extractChemical((long)availablePull, Action.SIMULATE) : (Object)connectedAcceptor.extractChemical(ChemicalUtil.copyWithAmount(bufferWithFallback.getChemicalStack(), availablePull), Action.SIMULATE);
        if (!received.isEmpty() && this.takeChemical(chemicalType, received, Action.SIMULATE).isEmpty()) {
            this.takeChemical(chemicalType, connectedAcceptor.extractChemical((long)received, Action.EXECUTE), Action.EXECUTE);
            return true;
        }
        return false;
    }

    private long getAvailablePull(ChemicalType chemicalType) {
        if (this.hasTransmitterNetwork()) {
            return Math.min(this.tier.getTubePullAmount(), ((BoxedChemicalNetwork)this.getTransmitterNetwork()).chemicalTank.getTankForType(chemicalType).getNeeded());
        }
        return Math.min(this.tier.getTubePullAmount(), this.chemicalTank.getTankForType(chemicalType).getNeeded());
    }

    @Override
    @Nullable
    public PressurizedTubeUpgradeData getUpgradeData() {
        return new PressurizedTubeUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.getShare());
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return data instanceof PressurizedTubeUpgradeData;
    }

    @Override
    public void parseUpgradeData(@NotNull PressurizedTubeUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.takeChemical(data.contents, Action.EXECUTE);
    }

    @Override
    public void read(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.read(provider, nbtTags);
        this.saveShare = nbtTags.contains("boxed_chemical", 10) ? BoxedChemicalStack.parseOptional(provider, nbtTags.getCompound("boxed_chemical")) : BoxedChemicalStack.EMPTY;
        this.setStackClearOthers(this.saveShare.getChemicalStack(), this.chemicalTank.getTankForType(this.saveShare.getChemicalType()));
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void setStackClearOthers(STACK stack, IChemicalTank<?, ?> tank) {
        tank.setStack(stack);
        for (IChemicalTank<?, ?> tankToClear : this.chemicalTank.getAllTanks()) {
            if (tank == tankToClear) continue;
            tankToClear.setEmpty();
        }
    }

    @Override
    @NotNull
    public CompoundTag write(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.write(provider, nbtTags);
        if (this.hasTransmitterNetwork()) {
            ((BoxedChemicalNetwork)this.getTransmitterNetwork()).validateSaveShares(this);
        }
        if (this.saveShare.isEmpty()) {
            nbtTags.remove("boxed_chemical");
        } else {
            nbtTags.put("boxed_chemical", this.saveShare.save(provider));
        }
        return nbtTags;
    }

    @Override
    public BoxedChemicalNetwork createEmptyNetworkWithID(UUID networkID) {
        return new BoxedChemicalNetwork(networkID);
    }

    @Override
    public BoxedChemicalNetwork createNetworkByMerging(Collection<BoxedChemicalNetwork> toMerge) {
        return new BoxedChemicalNetwork(toMerge);
    }

    @Override
    public CompatibleTransmitterValidator<BoxedChemicalHandler, BoxedChemicalNetwork, BoxedPressurizedTube> getNewOrphanValidator() {
        return new CompatibleTransmitterValidator.CompatibleChemicalTransmitterValidator(this);
    }

    @Override
    public boolean isValidTransmitter(TileEntityTransmitter transmitter, Direction side) {
        Transmitter<?, ?, ?> transmitter2;
        if (super.isValidTransmitter(transmitter, side) && (transmitter2 = transmitter.getTransmitter()) instanceof BoxedPressurizedTube) {
            BoxedChemical otherBuffer;
            BoxedPressurizedTube other = (BoxedPressurizedTube)transmitter2;
            BoxedChemical buffer = this.getBufferWithFallback().getType();
            if (buffer.isEmpty() && this.hasTransmitterNetwork() && ((BoxedChemicalNetwork)this.getTransmitterNetwork()).getPrevTransferAmount() > 0L) {
                buffer = ((BoxedChemicalNetwork)this.getTransmitterNetwork()).lastChemical;
            }
            if ((otherBuffer = other.getBufferWithFallback().getType()).isEmpty() && other.hasTransmitterNetwork() && ((BoxedChemicalNetwork)other.getTransmitterNetwork()).getPrevTransferAmount() > 0L) {
                otherBuffer = ((BoxedChemicalNetwork)other.getTransmitterNetwork()).lastChemical;
            }
            return buffer.isEmpty() || otherBuffer.isEmpty() || buffer.equals(otherBuffer);
        }
        return false;
    }

    @Override
    protected boolean canHaveIncompatibleNetworks() {
        return true;
    }

    @Override
    public long getCapacity() {
        return this.tier.getTubeCapacity();
    }

    @Override
    @NotNull
    public BoxedChemicalStack releaseShare() {
        BoxedChemicalStack ret;
        MergedChemicalTank.Current current = this.chemicalTank.getCurrent();
        if (current == MergedChemicalTank.Current.EMPTY) {
            ret = BoxedChemicalStack.EMPTY;
        } else {
            IChemicalTank<?, ?> tank = this.chemicalTank.getTankFromCurrent(current);
            ret = BoxedChemicalStack.box(tank.getStack());
            tank.setEmpty();
        }
        return ret;
    }

    @Override
    @NotNull
    public BoxedChemicalStack getShare() {
        MergedChemicalTank.Current current = this.chemicalTank.getCurrent();
        if (current == MergedChemicalTank.Current.EMPTY) {
            return BoxedChemicalStack.EMPTY;
        }
        return BoxedChemicalStack.box(this.chemicalTank.getTankFromCurrent(current).getStack());
    }

    @Override
    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback().isEmpty();
    }

    @Override
    @NotNull
    public BoxedChemicalStack getBufferWithFallback() {
        BoxedChemicalStack buffer = this.getShare();
        if (buffer.isEmpty() && this.hasTransmitterNetwork()) {
            return ((BoxedChemicalNetwork)this.getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    @Override
    public void takeShare() {
        if (this.hasTransmitterNetwork()) {
            BoxedChemicalNetwork transmitterNetwork = (BoxedChemicalNetwork)this.getTransmitterNetwork();
            MergedChemicalTank.Current networkCurrent = transmitterNetwork.chemicalTank.getCurrent();
            if (networkCurrent != MergedChemicalTank.Current.EMPTY && !this.saveShare.isEmpty()) {
                ChemicalStack<?> chemicalStack = this.saveShare.getChemicalStack();
                long amount = chemicalStack.getAmount();
                MekanismUtils.logMismatchedStackSize(transmitterNetwork.chemicalTank.getTankFromCurrent(networkCurrent).shrinkStack(amount, Action.EXECUTE), amount);
                this.setStackClearOthers(chemicalStack, this.chemicalTank.getTankFromCurrent(networkCurrent));
            }
        }
    }

    public void takeChemical(BoxedChemicalStack stack, Action action) {
        this.takeChemical(stack.getChemicalType(), stack.getChemicalStack(), action);
    }

    @NotNull
    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK takeChemical(ChemicalType type, STACK stack, Action action) {
        IChemicalTank<?, ?> tank = this.hasTransmitterNetwork() ? ((BoxedChemicalNetwork)this.getTransmitterNetwork()).chemicalTank.getTankForType(type) : this.chemicalTank.getTankForType(type);
        return (STACK)tank.insert(stack, action, AutomationType.INTERNAL);
    }

    @Override
    @NotNull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        if (this.hasTransmitterNetwork()) {
            return ((BoxedChemicalNetwork)this.getTransmitterNetwork()).getGasTanks(side);
        }
        return this.gasTanks;
    }

    @Override
    @NotNull
    public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        if (this.hasTransmitterNetwork()) {
            return ((BoxedChemicalNetwork)this.getTransmitterNetwork()).getInfusionTanks(side);
        }
        return this.infusionTanks;
    }

    @Override
    @NotNull
    public List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        if (this.hasTransmitterNetwork()) {
            return ((BoxedChemicalNetwork)this.getTransmitterNetwork()).getPigmentTanks(side);
        }
        return this.pigmentTanks;
    }

    @Override
    @NotNull
    public List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        if (this.hasTransmitterNetwork()) {
            return ((BoxedChemicalNetwork)this.getTransmitterNetwork()).getSlurryTanks(side);
        }
        return this.slurryTanks;
    }

    @Override
    public void onContentsChanged() {
        this.getTransmitterTile().setChanged();
    }

    @Override
    protected void handleContentsUpdateTag(@NotNull BoxedChemicalNetwork network, @NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleContentsUpdateTag(network, tag, provider);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            network.currentScale = scale;
        });
        NBTUtils.setBoxedChemicalIfPresent(provider, tag, "boxed_chemical", network::setLastChemical);
    }

    public IGasTank getGasTank() {
        return this.chemicalTank.getGasTank();
    }

    public IInfusionTank getInfusionTank() {
        return this.chemicalTank.getInfusionTank();
    }

    public IPigmentTank getPigmentTank() {
        return this.chemicalTank.getPigmentTank();
    }

    public ISlurryTank getSlurryTank() {
        return this.chemicalTank.getSlurryTank();
    }
}

