/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.LogisticalTransporterUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogisticalTransporter
extends LogisticalTransporterBase
implements IUpgradeableTransmitter<LogisticalTransporterUpgradeData> {
    @Nullable
    private EnumColor color;

    public LogisticalTransporter(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(tile, Attribute.getTier(blockProvider, TransporterTier.class));
    }

    @Override
    public TransporterTier getTier() {
        return this.tier;
    }

    @Override
    @Nullable
    public EnumColor getColor() {
        return this.color;
    }

    public void setColor(@Nullable EnumColor c) {
        this.color = c;
    }

    @Override
    public InteractionResult onConfigure(Player player, Direction side) {
        this.setColor(TransporterUtils.increment(this.getColor()));
        PathfinderCache.onChanged((InventoryNetwork)this.getTransmitterNetwork());
        this.getTransmitterTile().sendUpdatePacket();
        EnumColor color = this.getColor();
        player.displayClientMessage((Component)MekanismLang.TOGGLE_COLOR.translateColored(EnumColor.GRAY, color == null ? MekanismLang.NONE.translateColored(EnumColor.WHITE) : color.getColoredName()), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onRightClick(Player player, Direction side) {
        EnumColor color = this.getColor();
        player.displayClientMessage((Component)MekanismLang.CURRENT_COLOR.translateColored(EnumColor.GRAY, color == null ? MekanismLang.NONE.translateColored(EnumColor.WHITE) : color.getColoredName()), true);
        return super.onRightClick(player, side);
    }

    @Override
    @Nullable
    public LogisticalTransporterUpgradeData getUpgradeData() {
        return new LogisticalTransporterUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.getColor(), (Int2ObjectMap<TransporterStack>)this.transit, (Int2ObjectMap<TransporterStack>)this.needsSync, this.nextId, this.delay, this.delayCount);
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return data instanceof LogisticalTransporterUpgradeData;
    }

    @Override
    public void parseUpgradeData(@NotNull LogisticalTransporterUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.setColor(data.color);
        this.transit.putAll(data.transit);
        this.needsSync.putAll(data.needsSync);
        this.nextId = data.nextId;
        this.delay = data.delay;
        this.delayCount = data.delayCount;
    }

    @Override
    protected void readFromNBT(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.readFromNBT(provider, nbtTags);
        this.setColor(NBTUtils.getEnum(nbtTags, "color", EnumColor.BY_ID));
    }

    @Override
    public void writeToNBT(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.writeToNBT(provider, nbtTags);
        if (this.getColor() != null) {
            NBTUtils.writeEnum(nbtTags, "color", this.getColor());
        }
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider, CompoundTag updateTag) {
        updateTag = super.getReducedUpdateTag(provider, updateTag);
        if (this.getColor() != null) {
            NBTUtils.writeEnum(updateTag, "color", this.getColor());
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.setColor(NBTUtils.getEnum(tag, "color", EnumColor.BY_ID));
    }
}

