/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Chunk3D;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.lib.transmitter.CompatibleTransmitterValidator;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.tile.interfaces.ITileWrapper;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Transmitter<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER>>
implements ITileWrapper {
    private ConnectionType[] connectionTypes = new ConnectionType[]{ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL};
    private final AbstractAcceptorCache<ACCEPTOR, ?> acceptorCache;
    public byte currentTransmitterConnections = 0;
    private final TileEntityTransmitter transmitterTile;
    private final Set<TransmissionType> supportedTransmissionTypes;
    protected boolean redstoneReactive;
    private boolean redstonePowered;
    private boolean redstoneSet;
    private NETWORK theNetwork = null;
    private boolean orphaned = true;
    private boolean isUpgrading;

    public static boolean connectionMapContainsSide(byte connections, Direction side) {
        return Transmitter.connectionMapContainsSide(connections, side.ordinal());
    }

    private static boolean connectionMapContainsSide(byte connections, int sideOrdinal) {
        byte tester = (byte)(1 << sideOrdinal);
        return (connections & tester) > 0;
    }

    private static byte setConnectionBit(byte connections, boolean toSet, Direction side) {
        return (byte)(connections & ~((byte)(1 << side.ordinal())) | (byte)((toSet ? 1 : 0) << side.ordinal()));
    }

    private static ConnectionType getConnectionType(Direction side, byte allConnections, byte transmitterConnections, ConnectionType[] types) {
        int sideOrdinal = side.ordinal();
        if (!Transmitter.connectionMapContainsSide(allConnections, sideOrdinal)) {
            return ConnectionType.NONE;
        }
        if (Transmitter.connectionMapContainsSide(transmitterConnections, sideOrdinal)) {
            return ConnectionType.NORMAL;
        }
        return types[sideOrdinal];
    }

    public Transmitter(TileEntityTransmitter transmitterTile, TransmissionType ... transmissionTypes) {
        this.transmitterTile = transmitterTile;
        this.acceptorCache = this.createAcceptorCache();
        this.supportedTransmissionTypes = EnumSet.noneOf(TransmissionType.class);
        Collections.addAll(this.supportedTransmissionTypes, transmissionTypes);
    }

    protected abstract AbstractAcceptorCache<ACCEPTOR, ?> createAcceptorCache();

    public AbstractAcceptorCache<ACCEPTOR, ?> getAcceptorCache() {
        return this.acceptorCache;
    }

    public TileEntityTransmitter getTransmitterTile() {
        return this.transmitterTile;
    }

    public boolean isUpgrading() {
        return this.isUpgrading;
    }

    public ConnectionType[] getConnectionTypesRaw() {
        return this.connectionTypes;
    }

    public void setConnectionTypesRaw(@NotNull ConnectionType[] connectionTypes) {
        if (this.connectionTypes.length != connectionTypes.length) {
            throw new IllegalArgumentException("Mismatched connection types length");
        }
        this.connectionTypes = connectionTypes;
    }

    public ConnectionType getConnectionTypeRaw(@NotNull Direction side) {
        return this.connectionTypes[side.ordinal()];
    }

    public void setConnectionTypeRaw(@NotNull Direction side, @NotNull ConnectionType type) {
        int index = side.ordinal();
        ConnectionType old = this.connectionTypes[index];
        if (old != type) {
            this.connectionTypes[index] = type;
            this.getTransmitterTile().sideChanged(side, old, type);
        }
    }

    @Override
    public BlockPos getBlockPos() {
        return this.transmitterTile.getBlockPos();
    }

    @Override
    public Level getLevel() {
        return this.transmitterTile.getLevel();
    }

    @Override
    public GlobalPos getTileGlobalPos() {
        return this.transmitterTile.getTileGlobalPos();
    }

    @Override
    public Chunk3D getTileChunk() {
        return this.transmitterTile.getTileChunk();
    }

    public boolean isRemote() {
        return this.transmitterTile.isRemote();
    }

    protected TRANSMITTER getTransmitter() {
        return (TRANSMITTER)this;
    }

    public NETWORK getTransmitterNetwork() {
        return this.theNetwork;
    }

    public void setTransmitterNetwork(NETWORK network) {
        this.setTransmitterNetwork(network, true);
    }

    public boolean setTransmitterNetwork(NETWORK network, boolean requestNow) {
        if (this.theNetwork == network) {
            return false;
        }
        if (this.isRemote() && this.theNetwork != null) {
            ((DynamicNetwork)this.theNetwork).removeTransmitter(this.getTransmitter());
        }
        this.theNetwork = network;
        boolean bl = this.orphaned = this.theNetwork == null;
        if (this.isRemote()) {
            if (this.theNetwork != null) {
                ((DynamicNetwork)this.theNetwork).addTransmitter(this.getTransmitter());
            }
        } else if (requestNow) {
            this.requestsUpdate();
        } else {
            return true;
        }
        return false;
    }

    public boolean hasTransmitterNetwork() {
        return !this.isOrphan() && this.getTransmitterNetwork() != null;
    }

    public abstract NETWORK createEmptyNetworkWithID(UUID var1);

    public abstract NETWORK createNetworkByMerging(Collection<NETWORK> var1);

    public boolean isValid() {
        return !this.getTransmitterTile().isRemoved() && this.getTransmitterTile().isLoaded();
    }

    public CompatibleTransmitterValidator<ACCEPTOR, NETWORK, TRANSMITTER> getNewOrphanValidator() {
        return new CompatibleTransmitterValidator();
    }

    public boolean isOrphan() {
        return this.orphaned;
    }

    public void setOrphan(boolean nowOrphaned) {
        this.orphaned = nowOrphaned;
    }

    public Set<TransmissionType> getSupportedTransmissionTypes() {
        return this.supportedTransmissionTypes;
    }

    public boolean supportsTransmissionType(Transmitter<?, ?, ?> transmitter) {
        return transmitter.getSupportedTransmissionTypes().stream().anyMatch(this.supportedTransmissionTypes::contains);
    }

    public boolean supportsTransmissionType(TileEntityTransmitter transmitter) {
        return this.supportsTransmissionType(transmitter.getTransmitter());
    }

    @Nullable
    public ACCEPTOR getAcceptor(Direction side) {
        return this.acceptorCache.getCachedAcceptor(side);
    }

    public boolean handlesRedstone() {
        return true;
    }

    public final boolean isRedstoneActivated() {
        if (this.handlesRedstone() && this.redstoneReactive) {
            if (!this.redstoneSet) {
                this.setRedstoneState();
            }
            return this.redstonePowered;
        }
        return false;
    }

    public byte getPossibleTransmitterConnections() {
        byte connections = 0;
        if (this.isRedstoneActivated()) {
            return connections;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos pos = this.getBlockPos();
        for (Direction side : EnumUtils.DIRECTIONS) {
            mutable.setWithOffset((Vec3i)pos, side);
            TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)this.getLevel(), (BlockPos)mutable);
            if (tile == null || !this.isValidTransmitter(tile, side)) continue;
            connections = (byte)(connections | (byte)(1 << side.ordinal()));
        }
        return connections;
    }

    private boolean getPossibleAcceptorConnection(Direction side, boolean markDirty) {
        if (this.isRedstoneActivated()) {
            return false;
        }
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)this.getLevel(), this.getBlockPos().relative(side));
        if (this.canConnectMutual(side, tile) && this.isValidAcceptor(tile, side)) {
            return true;
        }
        if (markDirty) {
            this.markDirtyAcceptor(side);
        }
        return false;
    }

    private boolean getPossibleTransmitterConnection(Direction side) {
        if (this.isRedstoneActivated()) {
            return false;
        }
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)this.getLevel(), this.getBlockPos().relative(side));
        return tile != null && this.isValidTransmitter(tile, side);
    }

    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        if (this.isRedstoneActivated()) {
            return connections;
        }
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        BlockPos pos = this.getBlockPos();
        Level level = this.getLevel();
        for (Direction side : EnumUtils.DIRECTIONS) {
            offset.setWithOffset((Vec3i)pos, side);
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)level, (BlockPos)offset);
            if (this.canConnectMutual(side, tile)) {
                if (!this.isRemote() && !WorldUtils.isBlockLoaded((BlockGetter)level, (BlockPos)offset)) {
                    this.getTransmitterTile().setForceUpdate();
                    continue;
                }
                if (this.isValidAcceptor(tile, side)) {
                    connections = (byte)(connections | (byte)(1 << side.ordinal()));
                    continue;
                }
            }
            this.markDirtyAcceptor(side);
        }
        return connections;
    }

    public byte getAllCurrentConnections() {
        return (byte)(this.currentTransmitterConnections | this.acceptorCache.currentAcceptorConnections);
    }

    public boolean isValidTransmitter(TileEntityTransmitter transmitter, Direction side) {
        return this.isValidTransmitterBasic(transmitter, side);
    }

    public boolean isValidTransmitterBasic(TileEntityTransmitter transmitter, Direction side) {
        return this.supportsTransmissionType(transmitter) && this.canConnectMutual(side, transmitter);
    }

    public boolean canConnectToAcceptor(Direction side) {
        return this.getConnectionTypeRaw(side).canSendTo();
    }

    protected boolean isValidAcceptor(@Nullable BlockEntity tile, Direction side) {
        TileEntityTransmitter transmitter;
        if (!(tile instanceof TileEntityTransmitter) || !this.supportsTransmissionType(transmitter = (TileEntityTransmitter)tile)) {
            return this.getAcceptorCache().getConnectedAcceptor(side) != null;
        }
        return false;
    }

    public boolean canConnectMutual(Direction side, @Nullable BlockEntity cachedTile) {
        TileEntityTransmitter transmitter;
        if (!this.canConnect(side)) {
            return false;
        }
        if (cachedTile == null) {
            cachedTile = WorldUtils.getTileEntity((BlockGetter)this.getLevel(), this.getBlockPos().relative(side));
        }
        return !(cachedTile instanceof TileEntityTransmitter) || (transmitter = (TileEntityTransmitter)cachedTile).getTransmitter().canConnect(side.getOpposite());
    }

    public boolean canConnectMutual(Direction side, @Nullable TRANSMITTER cachedTransmitter) {
        if (!this.canConnect(side)) {
            return false;
        }
        return cachedTransmitter == null || ((Transmitter)cachedTransmitter).canConnect(side.getOpposite());
    }

    public boolean canConnect(Direction side) {
        if (this.getConnectionTypeRaw(side) == ConnectionType.NONE) {
            return false;
        }
        if (this.handlesRedstone() && this.redstoneReactive) {
            if (!this.redstoneSet) {
                this.setRedstoneState();
            }
            return !this.redstonePowered;
        }
        return true;
    }

    public void requestsUpdate() {
        this.getTransmitterTile().sendUpdatePacket();
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider, CompoundTag updateTag) {
        updateTag.putByte("connections", this.currentTransmitterConnections);
        updateTag.putByte("acceptors", this.acceptorCache.currentAcceptorConnections);
        updateTag.putIntArray("connection", this.getRawConnections());
        if (this.hasTransmitterNetwork()) {
            updateTag.putUUID("network", ((DynamicNetwork)this.getTransmitterNetwork()).getUUID());
        }
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        NBTUtils.setByteIfPresent(tag, "connections", connections -> {
            this.currentTransmitterConnections = connections;
        });
        NBTUtils.setByteIfPresent(tag, "acceptors", acceptors -> {
            this.acceptorCache.currentAcceptorConnections = acceptors;
        });
        this.readRawConnections(tag);
        NBTUtils.setUUIDIfPresentElse(tag, "network", networkID -> {
            if (this.hasTransmitterNetwork() && ((DynamicNetwork)this.getTransmitterNetwork()).getUUID().equals(networkID)) {
                return;
            }
            DynamicNetwork<?, ?, ?> clientNetwork = TransmitterNetworkRegistry.getInstance().getClientNetwork((UUID)networkID);
            if (clientNetwork == null) {
                NETWORK network = this.createEmptyNetworkWithID((UUID)networkID);
                ((DynamicNetwork)network).register();
                this.setTransmitterNetwork(network);
                this.handleContentsUpdateTag(network, tag, provider);
            } else {
                this.updateClientNetwork(clientNetwork);
            }
        }, () -> this.setTransmitterNetwork(null));
    }

    protected void updateClientNetwork(@NotNull NETWORK network) {
        ((DynamicNetwork)network).register();
        this.setTransmitterNetwork(network);
    }

    protected void handleContentsUpdateTag(@NotNull NETWORK network, @NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
    }

    public void read(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        this.redstoneReactive = nbtTags.getBoolean("redstone");
        NBTUtils.setByteIfPresent(nbtTags, "connections", connections -> {
            this.currentTransmitterConnections = connections;
        });
        NBTUtils.setByteIfPresent(nbtTags, "acceptors", acceptors -> {
            this.acceptorCache.currentAcceptorConnections = acceptors;
        });
        this.readRawConnections(nbtTags);
    }

    @NotNull
    public CompoundTag write(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        nbtTags.putBoolean("redstone", this.redstoneReactive);
        nbtTags.putByte("connections", this.currentTransmitterConnections);
        nbtTags.putByte("acceptors", this.acceptorCache.currentAcceptorConnections);
        nbtTags.putIntArray("connection", this.getRawConnections());
        return nbtTags;
    }

    private int[] getRawConnections() {
        int[] raw = new int[EnumUtils.DIRECTIONS.length];
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            raw[i] = this.getConnectionTypeRaw(EnumUtils.DIRECTIONS[i]).ordinal();
        }
        return raw;
    }

    private void readRawConnections(CompoundTag tag) {
        if (tag.contains("connection", 11)) {
            int[] raw = tag.getIntArray("connection");
            for (int i = 0; i < raw.length && i < EnumUtils.DIRECTIONS.length; ++i) {
                this.setConnectionTypeRaw(EnumUtils.DIRECTIONS[i], ConnectionType.BY_ID.apply(raw[i]));
            }
        }
    }

    private void recheckRedstone() {
        if (this.handlesRedstone()) {
            boolean previouslyPowered = this.redstonePowered;
            this.setRedstoneState();
            if (previouslyPowered != this.redstonePowered) {
                this.markDirtyTransmitters();
                this.getTransmitterTile().redstoneChanged(this.redstonePowered);
            }
        }
    }

    private void setRedstoneState() {
        this.redstonePowered = this.redstoneReactive && this.transmitterTile.hasLevel() && WorldUtils.isGettingPowered(this.getLevel(), this.getBlockPos());
        this.redstoneSet = true;
    }

    public void refreshConnections() {
        if (!this.isRemote()) {
            this.recheckRedstone();
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            byte possibleAcceptors = this.getPossibleAcceptorConnections();
            byte newlyEnabledTransmitters = 0;
            boolean sendDesc = false;
            if ((possibleTransmitters | possibleAcceptors) != this.getAllCurrentConnections()) {
                sendDesc = true;
                if (possibleTransmitters != this.currentTransmitterConnections) {
                    newlyEnabledTransmitters = (byte)(possibleTransmitters ^ this.currentTransmitterConnections);
                    newlyEnabledTransmitters = (byte)(newlyEnabledTransmitters & (byte)(~this.currentTransmitterConnections));
                }
            }
            this.currentTransmitterConnections = possibleTransmitters;
            this.acceptorCache.currentAcceptorConnections = possibleAcceptors;
            if (newlyEnabledTransmitters != 0) {
                this.recheckConnections(newlyEnabledTransmitters);
            }
            if (sendDesc) {
                this.getTransmitterTile().sendUpdatePacket();
            }
        }
    }

    public void refreshAcceptorConnections(Direction side) {
        boolean possibleAcceptor;
        if (!this.isRemote() && (possibleAcceptor = this.getPossibleAcceptorConnection(side, false)) != Transmitter.connectionMapContainsSide(this.acceptorCache.currentAcceptorConnections, side)) {
            this.acceptorCache.currentAcceptorConnections = Transmitter.setConnectionBit(this.acceptorCache.currentAcceptorConnections, possibleAcceptor, side);
            this.getTransmitterTile().sendUpdatePacket();
        }
    }

    public void refreshConnections(Direction side) {
        if (!this.isRemote()) {
            boolean possibleTransmitter = this.getPossibleTransmitterConnection(side);
            boolean possibleAcceptor = this.getPossibleAcceptorConnection(side, true);
            boolean transmitterChanged = false;
            boolean sendDesc = false;
            if ((possibleTransmitter || possibleAcceptor) != Transmitter.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
                sendDesc = true;
                if (possibleTransmitter != Transmitter.connectionMapContainsSide(this.currentTransmitterConnections, side)) {
                    transmitterChanged = possibleTransmitter;
                }
            }
            this.currentTransmitterConnections = Transmitter.setConnectionBit(this.currentTransmitterConnections, possibleTransmitter, side);
            this.acceptorCache.currentAcceptorConnections = Transmitter.setConnectionBit(this.acceptorCache.currentAcceptorConnections, possibleAcceptor, side);
            if (transmitterChanged) {
                this.recheckConnection(side);
            }
            if (sendDesc) {
                this.getTransmitterTile().sendUpdatePacket();
            }
        }
    }

    protected void recheckConnections(byte newlyEnabledTransmitters) {
        if (!this.hasTransmitterNetwork()) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            BlockPos pos = this.getBlockPos();
            for (Direction side : EnumUtils.DIRECTIONS) {
                if (!Transmitter.connectionMapContainsSide(newlyEnabledTransmitters, side)) continue;
                mutable.setWithOffset((Vec3i)pos, side);
                TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)this.getLevel(), (BlockPos)mutable);
                if (tile == null) continue;
                tile.getTransmitter().refreshConnections(side.getOpposite());
            }
        }
    }

    protected void recheckConnection(Direction side) {
    }

    public void onModeChange(Direction side) {
        this.markDirtyAcceptor(side);
        if (this.getPossibleTransmitterConnections() != this.currentTransmitterConnections) {
            this.markDirtyTransmitters();
        }
        this.getTransmitterTile().setChanged();
    }

    public void onNeighborBlockChange(Direction side) {
        if (this.handlesRedstone() && this.redstoneReactive) {
            this.refreshConnections();
        } else {
            this.refreshConnections(side);
        }
    }

    protected void markDirtyTransmitters() {
        this.notifyTileChange();
        if (this.hasTransmitterNetwork()) {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    public void markDirtyAcceptor(Direction side) {
        if (this.hasTransmitterNetwork()) {
            ((DynamicNetwork)this.getTransmitterNetwork()).acceptorChanged(this.getTransmitter(), side);
        }
    }

    public void remove() {
    }

    public ConnectionType getConnectionType(Direction side) {
        return Transmitter.getConnectionType(side, this.getAllCurrentConnections(), this.currentTransmitterConnections, this.connectionTypes);
    }

    public Set<Direction> getConnections(ConnectionType type) {
        EnumSet<Direction> sides = null;
        for (Direction side : EnumUtils.DIRECTIONS) {
            if (this.getConnectionType(side) != type) continue;
            if (sides == null) {
                sides = EnumSet.noneOf(Direction.class);
            }
            sides.add(side);
        }
        return sides == null ? Collections.emptySet() : sides;
    }

    public InteractionResult onConfigure(Player player, Direction side) {
        return InteractionResult.PASS;
    }

    public InteractionResult onRightClick(Player player, Direction side) {
        if (this.handlesRedstone()) {
            this.redstoneReactive = !this.redstoneReactive;
            this.refreshConnections();
            this.notifyTileChange();
            player.displayClientMessage((Component)MekanismLang.REDSTONE_SENSITIVITY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, BooleanStateDisplay.OnOff.of(this.redstoneReactive)), true);
        }
        return InteractionResult.SUCCESS;
    }

    public void notifyTileChange() {
        WorldUtils.notifyLoadedNeighborsOfTileChange(this.getLevel(), this.getBlockPos());
    }

    public abstract void takeShare();

    public void validateAndTakeShare() {
        this.takeShare();
    }

    public void startUpgrading() {
        this.isUpgrading = true;
        this.takeShare();
        this.setTransmitterNetwork(null);
    }
}

