/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.EnergyAcceptorCache;
import mekanism.common.tier.CableTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.upgrade.transmitter.UniversalCableUpgradeData;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniversalCable
extends BufferedTransmitter<IStrictEnergyHandler, EnergyNetwork, Long, UniversalCable>
implements IMekanismStrictEnergyHandler,
IUpgradeableTransmitter<UniversalCableUpgradeData> {
    public final CableTier tier;
    private final List<IEnergyContainer> energyContainers;
    public final BasicEnergyContainer buffer;
    public long lastWrite = 0L;

    public UniversalCable(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(tile, TransmissionType.ENERGY);
        this.tier = Attribute.getTier(blockProvider, CableTier.class);
        this.buffer = BasicEnergyContainer.create(this.getCapacity(), BasicEnergyContainer.alwaysFalse, BasicEnergyContainer.alwaysTrue, this);
        this.energyContainers = Collections.singletonList(this.buffer);
    }

    protected EnergyAcceptorCache createAcceptorCache() {
        return new EnergyAcceptorCache(this.getTransmitterTile());
    }

    public EnergyAcceptorCache getAcceptorCache() {
        return (EnergyAcceptorCache)super.getAcceptorCache();
    }

    @Override
    public CableTier getTier() {
        return this.tier;
    }

    @Override
    public void pullFromAcceptors() {
        Set<Direction> connections = this.getConnections(ConnectionType.PULL);
        if (!connections.isEmpty()) {
            for (IStrictEnergyHandler connectedAcceptor : this.getAcceptorCache().getConnectedAcceptors(connections)) {
                long received = connectedAcceptor.extractEnergy(this.getAvailablePull(), Action.SIMULATE);
                if (received <= 0L || this.takeEnergy(received, Action.SIMULATE) != 0L) continue;
                long remainder = this.takeEnergy(received, Action.EXECUTE);
                connectedAcceptor.extractEnergy(received - remainder, Action.EXECUTE);
            }
        }
    }

    private long getAvailablePull() {
        if (this.hasTransmitterNetwork()) {
            return Math.min(this.getCapacity(), ((EnergyNetwork)this.getTransmitterNetwork()).energyContainer.getNeeded());
        }
        return Math.min(this.getCapacity(), this.buffer.getNeeded());
    }

    @Override
    @NotNull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        if (this.hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitterNetwork()).getEnergyContainers(side);
        }
        return this.energyContainers;
    }

    @Override
    public void onContentsChanged() {
        this.getTransmitterTile().setChanged();
    }

    @Override
    @Nullable
    public UniversalCableUpgradeData getUpgradeData() {
        return new UniversalCableUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.buffer);
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return data instanceof UniversalCableUpgradeData;
    }

    @Override
    public void parseUpgradeData(@NotNull UniversalCableUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.buffer.setEnergy(data.buffer.getEnergy());
    }

    @Override
    public void read(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.read(provider, nbtTags);
        this.lastWrite = nbtTags.getLong("energy");
        this.buffer.setEnergy(this.lastWrite);
    }

    @Override
    @NotNull
    public CompoundTag write(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.write(provider, nbtTags);
        if (this.hasTransmitterNetwork()) {
            ((EnergyNetwork)this.getTransmitterNetwork()).validateSaveShares(this);
        }
        if (this.lastWrite == 0L) {
            nbtTags.remove("energy");
        } else {
            nbtTags.putLong("energy", this.lastWrite);
        }
        return nbtTags;
    }

    @Override
    public EnergyNetwork createNetworkByMerging(Collection<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public EnergyNetwork createEmptyNetworkWithID(UUID networkID) {
        return new EnergyNetwork(networkID);
    }

    @Override
    @NotNull
    public Long releaseShare() {
        long energy = this.buffer.getEnergy();
        this.buffer.setEmpty();
        return energy;
    }

    @Override
    @NotNull
    public Long getShare() {
        return this.buffer.getEnergy();
    }

    @Override
    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback() == 0L;
    }

    @Override
    @NotNull
    public Long getBufferWithFallback() {
        long buffer = this.getShare();
        if (buffer == 0L && this.hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    @Override
    public void takeShare() {
        if (this.hasTransmitterNetwork()) {
            EnergyNetwork transmitterNetwork = (EnergyNetwork)this.getTransmitterNetwork();
            if (!transmitterNetwork.energyContainer.isEmpty() && this.lastWrite != 0L) {
                transmitterNetwork.energyContainer.setEnergy(transmitterNetwork.energyContainer.getEnergy() - this.lastWrite);
                this.buffer.setEnergy(this.lastWrite);
            }
        }
    }

    @Override
    public long getCapacity() {
        return this.tier.getCableCapacity();
    }

    private long takeEnergy(long amount, Action action) {
        if (this.hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitterNetwork()).energyContainer.insert(amount, action, AutomationType.INTERNAL);
        }
        return this.buffer.insert(amount, action, AutomationType.INTERNAL);
    }

    @Override
    protected void handleContentsUpdateTag(@NotNull EnergyNetwork network, @NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleContentsUpdateTag(network, tag, provider);
        NBTUtils.setLegacyEnergyIfPresent(tag, "energy", network.energyContainer::setEnergy);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            network.currentScale = scale;
        });
    }
}

