/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.oredictionificator;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.Supplier;
import mekanism.common.config.value.CachedOredictionificatorConfigValue;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OredictionificatorFilter<TYPE, STACK, FILTER extends OredictionificatorFilter<TYPE, STACK, FILTER>>
extends BaseFilter<FILTER> {
    @Nullable
    TagKey<TYPE> filterLocation;
    @Nullable
    private HolderSet.Named<TYPE> filterTag;
    @NotNull
    Holder<TYPE> selectedOutput = this.getFallbackElement();
    @Nullable
    private STACK cachedSelectedStack;
    boolean isValid;

    protected static <TYPE, STACK, FILTER extends OredictionificatorFilter<TYPE, STACK, FILTER>> Products.P3<RecordCodecBuilder.Mu<FILTER>, Boolean, Optional<TagKey<TYPE>>, Holder<TYPE>> baseOredictionificatorCodec(RecordCodecBuilder.Instance<FILTER> instance, ResourceKey<? extends Registry<TYPE>> registryName, Registry<TYPE> registry) {
        return OredictionificatorFilter.baseCodec(instance).and((App)TagKey.codec(registryName).optionalFieldOf("filter").forGetter(filter -> Optional.ofNullable(filter.filterLocation))).and((App)registry.holderByNameCodec().fieldOf("selected").forGetter(filter -> filter.selectedOutput));
    }

    protected static <TYPE, STACK, FILTER extends OredictionificatorFilter<TYPE, STACK, FILTER>> StreamCodec<RegistryFriendlyByteBuf, FILTER> baseOredictionificatorStreamCodec(Supplier<FILTER> constructor, ResourceKey<? extends Registry<TYPE>> registry) {
        return StreamCodec.composite(BaseFilter.baseStreamCodec(constructor), Function.identity(), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), filter -> Optional.ofNullable(filter.filterLocation).map(TagKey::location), (StreamCodec)ByteBufCodecs.holderRegistry(registry), filter -> filter.selectedOutput, (StreamCodec)ByteBufCodecs.BOOL, filter -> filter.isValid, (filter, filterLocation, selected, valid) -> {
            filter.setFilter(filterLocation.orElse(null));
            filter.setSelectedOutput((Holder)selected);
            filter.isValid = valid;
            return filter;
        });
    }

    protected OredictionificatorFilter() {
    }

    protected OredictionificatorFilter(boolean enabled, @Nullable TagKey<TYPE> filterLocation, Holder<TYPE> selectedOutput) {
        super(enabled);
        this.filterLocation = filterLocation;
        this.flushCachedTag();
        this.setSelectedOutput(selectedOutput);
        this.checkValidity();
    }

    protected OredictionificatorFilter(FILTER other) {
        super(other);
        FILTER filter = other;
        this.filterLocation = ((OredictionificatorFilter)filter).filterLocation;
        this.filterTag = ((OredictionificatorFilter)filter).filterTag;
        this.selectedOutput = ((OredictionificatorFilter)filter).selectedOutput;
        this.cachedSelectedStack = ((OredictionificatorFilter)filter).cachedSelectedStack;
        this.isValid = ((OredictionificatorFilter)filter).isValid;
    }

    public void flushCachedTag() {
        HolderSet.Named<TYPE> named = this.filterTag = this.filterLocation == null ? null : (HolderSet.Named<TYPE>)this.getRegistry().getTag(this.filterLocation).orElse(null);
        if (this.filterTag == null) {
            this.setSelectedOutput(this.getFallbackElement());
        } else if (!this.filterTag.contains(this.selectedOutput)) {
            this.filterTag.stream().findFirst().ifPresentOrElse(this::setSelectedOutput, this::setToFallback);
        }
    }

    @Override
    public boolean hasFilter() {
        return this.filterLocation != null && this.isValid;
    }

    public void checkValidity() {
        if (this.filterLocation != null && this.getRegistry().getTag(this.filterLocation).isPresent()) {
            for (String filter : ((Map)this.getValidValuesConfig().get()).getOrDefault(this.filterLocation.location().getNamespace(), Collections.emptyList())) {
                if (!this.filterLocation.location().getPath().startsWith(filter)) continue;
                this.isValid = true;
                return;
            }
        }
        this.isValid = false;
    }

    @ComputerMethod(nameOverride="getFilter", threadSafe=true)
    public String getFilterText() {
        return this.filterLocation == null ? "" : this.filterLocation.location().toString();
    }

    public final void setFilter(@Nullable ResourceLocation location) {
        this.filterLocation = location == null ? null : TagKey.create((ResourceKey)this.getRegistry().key(), (ResourceLocation)location);
        this.flushCachedTag();
        this.isValid = true;
    }

    @ComputerMethod(nameOverride="setFilter")
    public void computerSetFilter(ResourceLocation tag) throws ComputerException {
        if (tag == null || !TileEntityOredictionificator.isValidTarget(tag)) {
            throw new ComputerException("Invalid tag");
        }
        this.setFilter(tag);
    }

    public final void setSelectedOutput(@NotNull Holder<TYPE> output) {
        this.selectedOutput = output;
        this.cachedSelectedStack = null;
    }

    public boolean filterMatches(ResourceLocation location) {
        return this.filterLocation != null && this.filterLocation.location().equals((Object)location);
    }

    private void setToFallback() {
        this.setSelectedOutput(this.getFallbackElement());
    }

    private void setSelectedOrFallback(@NotNull ResourceLocation resourceLocation) {
        Registry<TYPE> registry = this.getRegistry();
        registry.getHolder(ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)resourceLocation)).ifPresentOrElse(this::setSelectedOutput, this::setToFallback);
    }

    public STACK getResult() {
        if (this.cachedSelectedStack == null) {
            if (this.filterTag == null || this.filterTag.size() == 0) {
                this.cachedSelectedStack = this.getEmptyStack();
            } else {
                if (this.selectedOutput == this.getFallbackElement() || !this.filterTag.contains(this.selectedOutput)) {
                    this.selectedOutput = this.filterTag.get(0);
                }
                this.cachedSelectedStack = this.createResultStack(this.selectedOutput.value());
            }
        }
        return this.cachedSelectedStack;
    }

    public final void next() {
        this.adjustSelected((index, size) -> {
            if (index < size - 1) {
                return index + 1;
            }
            return 0;
        });
    }

    public final void previous() {
        this.adjustSelected((index, size) -> {
            if (index == -1) {
                return 0;
            }
            if (index > 0) {
                return index - 1;
            }
            return size - 1;
        });
    }

    private void adjustSelected(IntBinaryOperator calculateSelected) {
        if (this.filterTag == null) {
            return;
        }
        int size = this.filterTag.size();
        if (size > 1) {
            int selected;
            if (this.selectedOutput == this.getFallbackElement()) {
                selected = size - 1;
            } else {
                List matchingElements = this.filterTag.stream().toList();
                selected = calculateSelected.applyAsInt(matchingElements.indexOf(this.selectedOutput), size);
            }
            this.setSelectedOutput(this.filterTag.get(selected));
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filterLocation, this.selectedOutput);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        OredictionificatorFilter other = (OredictionificatorFilter)o;
        return Objects.equals(this.filterLocation, other.filterLocation) && this.selectedOutput == other.selectedOutput;
    }

    public abstract TYPE getResultElement();

    protected abstract Registry<TYPE> getRegistry();

    protected abstract Holder<TYPE> getFallbackElement();

    protected abstract STACK getEmptyStack();

    protected abstract STACK createResultStack(TYPE var1);

    protected abstract CachedOredictionificatorConfigValue getValidValuesConfig();

    @Override
    @ComputerMethod(threadSafe=true)
    public abstract FILTER clone();
}

