/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio.filter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.lib.inventory.Finder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class QIOItemStackFilter
extends QIOFilter<QIOItemStackFilter>
implements IItemStackFilter<QIOItemStackFilter> {
    public static final MapCodec<QIOItemStackFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> QIOItemStackFilter.baseQIOCodec(instance).and((App)ItemStack.OPTIONAL_CODEC.fieldOf("target_stack").forGetter(QIOItemStackFilter::getItemStack)).and((App)Codec.BOOL.optionalFieldOf("fuzzy", (Object)false).forGetter(filter -> filter.fuzzyMode)).apply((Applicative)instance, QIOItemStackFilter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, QIOItemStackFilter> STREAM_CODEC = StreamCodec.composite(QIOItemStackFilter.baseQIOStreamCodec(QIOItemStackFilter::new), Function.identity(), (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, QIOItemStackFilter::getItemStack, (StreamCodec)ByteBufCodecs.BOOL, filter -> filter.fuzzyMode, (filter, itemType, fuzzyMode) -> {
        filter.itemType = itemType;
        filter.fuzzyMode = fuzzyMode;
        return filter;
    });
    private ItemStack itemType = ItemStack.EMPTY;
    public boolean fuzzyMode;

    public QIOItemStackFilter() {
    }

    protected QIOItemStackFilter(boolean enabled, ItemStack itemType, boolean fuzzyMode) {
        super(enabled);
        this.itemType = itemType;
        this.fuzzyMode = fuzzyMode;
    }

    public QIOItemStackFilter(QIOItemStackFilter filter) {
        super(filter);
        this.itemType = filter.itemType.copy();
        this.fuzzyMode = filter.fuzzyMode;
    }

    @Override
    public Finder getFinder() {
        return this.fuzzyMode ? Finder.item(this.itemType) : Finder.strict(this.itemType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.itemType.getItem(), this.fuzzyMode);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        QIOItemStackFilter other = (QIOItemStackFilter)o;
        if (this.fuzzyMode == other.fuzzyMode) {
            if (this.fuzzyMode) {
                return this.itemType.getItem() == other.itemType.getItem();
            }
            return ItemStack.isSameItemSameComponents((ItemStack)this.itemType, (ItemStack)other.itemType);
        }
        return false;
    }

    @Override
    public QIOItemStackFilter clone() {
        return new QIOItemStackFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.QIO_ITEMSTACK_FILTER;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@NotNull ItemStack stack) {
        this.itemType = stack;
    }
}

