/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio.filter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.function.Function;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.lib.inventory.Finder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class QIOTagFilter
extends QIOFilter<QIOTagFilter>
implements ITagFilter<QIOTagFilter> {
    public static final MapCodec<QIOTagFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> QIOTagFilter.baseQIOCodec(instance).and((App)Codec.STRING.fieldOf("tag").forGetter(QIOTagFilter::getTagName)).apply((Applicative)instance, QIOTagFilter::new));
    public static final StreamCodec<ByteBuf, QIOTagFilter> STREAM_CODEC = StreamCodec.composite(QIOTagFilter.baseQIOStreamCodec(QIOTagFilter::new), Function.identity(), (StreamCodec)ByteBufCodecs.STRING_UTF8, QIOTagFilter::getTagName, (filter, tagName) -> {
        filter.tagName = tagName;
        return filter;
    });
    private String tagName;

    public QIOTagFilter() {
    }

    protected QIOTagFilter(boolean enabled, String tagName) {
        super(enabled);
        this.tagName = tagName;
    }

    public QIOTagFilter(QIOTagFilter filter) {
        super(filter);
        this.tagName = filter.tagName;
    }

    @Override
    public Finder getFinder() {
        return Finder.tag(this.tagName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tagName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        QIOTagFilter other = (QIOTagFilter)o;
        return this.tagName.equals(other.tagName);
    }

    @Override
    public QIOTagFilter clone() {
        return new QIOTagFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.QIO_TAG_FILTER;
    }

    @Override
    public void setTagName(String name) {
        this.tagName = name;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }
}

