/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityFlame
extends Projectile
implements IEntityWithComplexSpawn {
    public static final int LIFESPAN = 80;
    private static final int DAMAGE = 10;

    public EntityFlame(EntityType<EntityFlame> type, Level world) {
        super(type, world);
    }

    @Nullable
    public static EntityFlame create(Level level, LivingEntity owner, InteractionHand hand, ItemFlamethrower.FlamethrowerMode mode) {
        EntityFlame flame = (EntityFlame)((EntityType)MekanismEntityTypes.FLAME.get()).create(level);
        if (flame == null) {
            return null;
        }
        Pos3D ownerPos = new Pos3D(owner.getX(), owner.getEyeY() - 0.1, owner.getZ());
        Pos3D flameVec = new Pos3D(1.0, 1.0, 1.0);
        boolean rightHanded = MekanismUtils.isRightArm(owner, hand);
        Vec3 lookVec = owner.getLookAngle();
        flameVec = flameVec.multiply(lookVec).yRot(rightHanded ? 10.0f : -10.0f);
        Vec3 mergedVec = ownerPos.add(flameVec);
        flame.setPos(mergedVec.x, mergedVec.y, mergedVec.z);
        flame.setOwner((Entity)owner);
        flame.setData((Supplier)((Object)MekanismAttachmentTypes.FLAMETHROWER_MODE), mode);
        flame.shootFromRotation((Entity)owner, owner.getXRot(), owner.getYRot(), 0.0f, 0.5f, 1.0f);
        BlockHitResult blockRayTrace = level.clip(new ClipContext((Vec3)ownerPos, mergedVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)flame));
        if (blockRayTrace.getType() != HitResult.Type.MISS) {
            flame.onHit((HitResult)blockRayTrace);
        }
        return flame;
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        block5: {
            block6: {
                block4: {
                    super.tick();
                    if (this.tickCount <= 80) break block4;
                    this.discard();
                    break block5;
                }
                localVec = this.position();
                motion = this.getDeltaMovement();
                motionVec = localVec.add(motion);
                hitResult = this.level().clip(new ClipContext(localVec, motionVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this));
                if (hitResult.getType() != HitResult.Type.MISS) {
                    motionVec = hitResult.getLocation();
                }
                if ((entityResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)localVec, (Vec3)motionVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), (Predicate<Entity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$tick$0(mekanism.common.entity.EntityFlame net.minecraft.world.entity.Entity ), (Lnet/minecraft/world/entity/Entity;)Z)((EntityFlame)this))) == null || entityResult.getType() != HitResult.Type.ENTITY) break block6;
                var8_6 = entityResult.getEntity();
                if (!(var8_6 instanceof Player)) ** GOTO lbl-1000
                target = (Player)var8_6;
                var8_6 = this.getOwner();
                if (var8_6 instanceof Player && !(owner = (Player)var8_6).canHarmPlayer(target)) {
                    hitResult = null;
                } else lbl-1000:
                // 2 sources

                {
                    hitResult = entityResult;
                }
            }
            if (hitResult != null && hitResult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
                this.onHit((HitResult)hitResult);
            }
            this.setPos(motionVec.x, motionVec.y, motionVec.z);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onHitEntity(EntityHitResult entityResult) {
        block5: {
            entity = entityResult.getEntity();
            if (entity instanceof Player) {
                player = (Player)entity;
                owner = this.getOwner();
                if (player.getAbilities().invulnerable || owner instanceof Player && !(o = (Player)owner).canHarmPlayer(player)) {
                    return;
                }
            }
            if (entity.fireImmune()) break block5;
            if (!(entity instanceof ItemEntity)) ** GOTO lbl-1000
            item = (ItemEntity)entity;
            if (this.getData((Supplier)MekanismAttachmentTypes.FLAMETHROWER_MODE) == ItemFlamethrower.FlamethrowerMode.HEAT) {
                if (entity.tickCount > 100 && !this.smeltItem(item)) {
                    this.burn(entity);
                }
            } else lbl-1000:
            // 2 sources

            {
                this.burn(entity);
            }
        }
        this.discard();
    }

    protected void onHitBlock(@NotNull BlockHitResult blockRayTrace) {
        boolean hitFluid;
        super.onHitBlock(blockRayTrace);
        BlockPos hitPos = blockRayTrace.getBlockPos();
        Direction hitSide = blockRayTrace.getDirection();
        BlockState hitState = this.level().getBlockState(hitPos);
        boolean bl = hitFluid = !hitState.getFluidState().isEmpty();
        if (!this.level().isClientSide && MekanismConfig.general.aestheticWorldDamage.get() && !hitFluid) {
            ItemFlamethrower.FlamethrowerMode mode = (ItemFlamethrower.FlamethrowerMode)this.getData((Supplier)((Object)MekanismAttachmentTypes.FLAMETHROWER_MODE));
            if (mode == ItemFlamethrower.FlamethrowerMode.HEAT) {
                Entity owner = this.getOwner();
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    this.smeltBlock(player, hitState, hitPos, hitSide);
                }
            } else if (mode == ItemFlamethrower.FlamethrowerMode.INFERNO) {
                Player player;
                Entity owner = this.getOwner();
                BlockPos sidePos = hitPos.relative(hitSide);
                UseOnContext igniterContext = new UseOnContext(this.level(), owner instanceof Player ? (player = (Player)owner) : null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.FIRE_CHARGE), blockRayTrace);
                if (!this.tryModify(owner, hitPos, hitSide, hitState, igniterContext, ItemAbilities.FIRESTARTER_LIGHT)) {
                    if (BaseFireBlock.canBePlacedAt((Level)this.level(), (BlockPos)sidePos, (Direction)hitSide)) {
                        this.tryPlace(owner, sidePos, hitSide, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)sidePos));
                    } else if (hitState.isFlammable((BlockGetter)this.level(), hitPos, hitSide)) {
                        LivingEntity livingEntity;
                        hitState.onCaughtFire(this.level(), hitPos, hitSide, owner instanceof LivingEntity ? (livingEntity = (LivingEntity)owner) : null);
                        if (hitState.getBlock() instanceof TntBlock) {
                            this.level().removeBlock(hitPos, false);
                        }
                    }
                }
            }
        }
        if (hitFluid) {
            this.spawnParticlesAt(this.blockPosition());
            this.playSound(SoundEvents.FIRE_EXTINGUISH, 1.0f, 1.0f);
        }
        this.discard();
    }

    private boolean tryModify(@Nullable Entity shooter, BlockPos pos, Direction hitSide, BlockState state, UseOnContext context, ItemAbility ability) {
        BlockSnapshot blockSnapshot = BlockSnapshot.create((ResourceKey)this.level().dimension(), (LevelAccessor)this.level(), (BlockPos)pos);
        BlockState modifiedState = state.getToolModifiedState(context, ability, false);
        if (modifiedState != null) {
            this.level().setBlockAndUpdate(pos, modifiedState);
        }
        if (modifiedState == null || EventHooks.onBlockPlace((Entity)shooter, (BlockSnapshot)blockSnapshot, (Direction)hitSide)) {
            this.level().restoringBlockSnapshots = true;
            blockSnapshot.restore(blockSnapshot.getFlags() | 2);
            this.level().restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }

    private boolean tryPlace(@Nullable Entity shooter, BlockPos pos, Direction hitSide, BlockState newState) {
        BlockSnapshot blockSnapshot = BlockSnapshot.create((ResourceKey)this.level().dimension(), (LevelAccessor)this.level(), (BlockPos)pos);
        this.level().setBlockAndUpdate(pos, newState);
        if (EventHooks.onBlockPlace((Entity)shooter, (BlockSnapshot)blockSnapshot, (Direction)hitSide)) {
            this.level().restoringBlockSnapshots = true;
            blockSnapshot.restore(blockSnapshot.getFlags() | 2);
            this.level().restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }

    private boolean smeltItem(ItemEntity item) {
        Level level;
        Optional recipe;
        ItemStack stack = item.getItem();
        if (!stack.isEmpty() && (recipe = MekanismRecipeType.getRecipeFor(RecipeType.SMELTING, new SingleRecipeInput(stack), level = this.level())).isPresent()) {
            ItemStack result = ((SmeltingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)level.registryAccess());
            item.setItem(result.copyWithCount(result.getCount() * stack.getCount()));
            item.tickCount = 0;
            this.spawnParticlesAt(item.blockPosition());
            this.playSound(SoundEvents.FIRE_EXTINGUISH, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void smeltBlock(Player shooter, BlockState hitState, BlockPos blockPos, Direction hitSide) {
        Optional recipe;
        if (hitState.isAir()) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)hitState.getBlock());
        if (stack.isEmpty()) {
            return;
        }
        try {
            recipe = MekanismRecipeType.getRecipeFor(RecipeType.SMELTING, new SingleRecipeInput(stack), this.level());
        }
        catch (Exception e) {
            return;
        }
        if (recipe.isPresent() && !this.level().isClientSide) {
            if (((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(this.level(), blockPos, hitState, shooter))).isCanceled()) {
                return;
            }
            ItemStack result = ((SmeltingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)this.level().registryAccess());
            if (!(result.getItem() instanceof BlockItem) || !this.tryPlace((Entity)shooter, blockPos, hitSide, Block.byItem((Item)result.getItem()).defaultBlockState())) {
                this.level().removeBlock(blockPos, false);
                ItemEntity item = new ItemEntity(this.level(), (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, result.copy());
                item.setDeltaMovement(0.0, 0.0, 0.0);
                this.level().addFreshEntity((Entity)item);
            }
            this.level().levelEvent(2001, blockPos, Block.getId((BlockState)hitState));
            this.spawnParticlesAt((ServerLevel)this.level(), blockPos);
        }
    }

    private void burn(Entity entity) {
        if (!(entity instanceof ItemEntity) || MekanismConfig.gear.flamethrowerDestroyItems.get()) {
            entity.setRemainingFireTicks(20);
            entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 10.0f);
        }
    }

    private void spawnParticlesAt(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + ((double)this.random.nextFloat() - 0.5), (double)pos.getY() + ((double)this.random.nextFloat() - 0.5), (double)pos.getZ() + ((double)this.random.nextFloat() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    private void spawnParticlesAt(ServerLevel world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            world.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + ((double)this.random.nextFloat() - 0.5), (double)pos.getY() + ((double)this.random.nextFloat() - 0.5), (double)pos.getZ() + ((double)this.random.nextFloat() - 0.5), 3, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.getData((Supplier)((Object)MekanismAttachmentTypes.FLAMETHROWER_MODE)));
    }

    public void readSpawnData(RegistryFriendlyByteBuf buffer) {
        this.setData((Supplier)((Object)MekanismAttachmentTypes.FLAMETHROWER_MODE), (ItemFlamethrower.FlamethrowerMode)buffer.readEnum(ItemFlamethrower.FlamethrowerMode.class));
    }

    private static /* synthetic */ boolean lambda$tick$0(EntityFlame rec$, Entity x$0) {
        return rec$.canHitEntity(x$0);
    }
}

