/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.providers.IGasProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LazyGasProvider
implements IGasProvider {
    private Supplier<Gas> gasSupplier;
    private Gas gas = MekanismAPI.EMPTY_GAS;

    public LazyGasProvider(ResourceLocation gasRegistryName) {
        this(() -> (Gas)MekanismAPI.GAS_REGISTRY.get(gasRegistryName));
    }

    public LazyGasProvider(Supplier<Gas> gasSupplier) {
        this.gasSupplier = gasSupplier;
    }

    @Override
    @NotNull
    public Gas getChemical() {
        if (this.gas.isEmptyType()) {
            this.gas = (Gas)this.gasSupplier.get().getChemical();
            if (this.gas.isEmptyType()) {
                throw new IllegalStateException("Empty gas used for coolant attribute via a CraftTweaker Script.");
            }
            this.gasSupplier = null;
        }
        return this.gas;
    }
}

