/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class SpecialComputerMethodWrapper {

    public static class ComputerHeatCapacitorWrapper
    extends SpecialComputerMethodWrapper {
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the temperature of the %s in Kelvin.")
        public static double getTemperature(IHeatCapacitor capacitor) {
            return capacitor.getTemperature();
        }
    }

    public static class ComputerIInventorySlotWrapper
    extends SpecialComputerMethodWrapper {
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the contents of the %s.")
        public static ItemStack getStack(IInventorySlot slot) {
            return slot.getStack();
        }
    }

    public static class ComputerFluidTankWrapper
    extends SpecialComputerMethodWrapper {
        @WrappingComputerMethod.WrappingComputerMethodIndex(value=0)
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the contents of the %s.")
        public static FluidStack getStack(IExtendedFluidTank tank) {
            return tank.getFluid();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=1)
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the capacity of the %s.")
        public static int getCapacity(IExtendedFluidTank tank) {
            return tank.getCapacity();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=2)
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the amount needed to fill the %s.")
        public static int getNeeded(IExtendedFluidTank tank) {
            return tank.getNeeded();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=3)
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the filled percentage of the %s.")
        public static double getFilledPercentage(IExtendedFluidTank tank) {
            return (double)tank.getFluidAmount() / (double)tank.getCapacity();
        }
    }

    public static class ComputerChemicalTankWrapper
    extends SpecialComputerMethodWrapper {
        @WrappingComputerMethod.WrappingComputerMethodIndex(value=0)
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the contents of the %s.")
        public static ChemicalStack<?> getStack(IChemicalTank<?, ?> tank) {
            return tank.getStack();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=1)
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the capacity of the %s.")
        public static long getCapacity(IChemicalTank<?, ?> tank) {
            return tank.getCapacity();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=2)
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the amount needed to fill the %s.")
        public static long getNeeded(IChemicalTank<?, ?> tank) {
            return tank.getNeeded();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=3)
        @WrappingComputerMethod.WrappingComputerMethodHelp(value="Get the filled percentage of the %s.")
        public static double getFilledPercentage(IChemicalTank<?, ?> tank) {
            return (double)tank.getStored() / (double)tank.getCapacity();
        }
    }
}

