/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.natives.ingredient.ExpandCTFluidIngredientNeoForge;
import com.blamejared.crafttweaker.natives.ingredient.ExpandIIngredientWithAmountNeoForge;
import com.blamejared.crafttweaker.natives.ingredient.ExpandSizedFluidIngredient;
import com.blamejared.crafttweaker.natives.ingredient.ExpandSizedIngredient;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public class CrTUtils {
    public static final Function<GasStack, ICrTChemicalStack.ICrTGasStack> GAS_CONVERTER = CrTChemicalStack.CrTGasStack::new;
    public static final Function<InfusionStack, ICrTChemicalStack.ICrTInfusionStack> INFUSION_CONVERTER = CrTChemicalStack.CrTInfusionStack::new;
    public static final Function<PigmentStack, ICrTChemicalStack.ICrTPigmentStack> PIGMENT_CONVERTER = CrTChemicalStack.CrTPigmentStack::new;
    public static final Function<SlurryStack, ICrTChemicalStack.ICrTSlurryStack> SLURRY_CONVERTER = CrTChemicalStack.CrTSlurryStack::new;

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"crafttweaker", (String)path);
    }

    public static ICrTChemicalStack.ICrTGasStack stackFromGas(Gas gas) {
        return new CrTChemicalStack.CrTGasStack(gas.getStack(1L));
    }

    public static ICrTChemicalStack.ICrTInfusionStack stackFromInfuseType(InfuseType infuseType) {
        return new CrTChemicalStack.CrTInfusionStack(infuseType.getStack(1L));
    }

    public static ICrTChemicalStack.ICrTPigmentStack stackFromPigment(Pigment pigment) {
        return new CrTChemicalStack.CrTPigmentStack(pigment.getStack(1L));
    }

    public static ICrTChemicalStack.ICrTSlurryStack stackFromSlurry(Slurry slurry) {
        return new CrTChemicalStack.CrTSlurryStack(slurry.getStack(1L));
    }

    @Nullable
    public static ICrTChemicalStack<?, ?, ?> fromBoxedStack(BoxedChemicalStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return switch (stack.getChemicalType()) {
            default -> throw new MatchException(null, null);
            case ChemicalType.GAS -> new CrTChemicalStack.CrTGasStack((GasStack)stack.getChemicalStack());
            case ChemicalType.INFUSION -> new CrTChemicalStack.CrTInfusionStack((InfusionStack)stack.getChemicalStack());
            case ChemicalType.PIGMENT -> new CrTChemicalStack.CrTPigmentStack((PigmentStack)stack.getChemicalStack());
            case ChemicalType.SLURRY -> new CrTChemicalStack.CrTSlurryStack((SlurryStack)stack.getChemicalStack());
        };
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, ?, CRT_STACK>> CRT_STACK fromChemical(CHEMICAL chemical, int size) {
        CHEMICAL CHEMICAL = chemical;
        Objects.requireNonNull(CHEMICAL);
        CHEMICAL CHEMICAL2 = CHEMICAL;
        int n = 0;
        return (CRT_STACK)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Gas.class, InfuseType.class, Pigment.class, Slurry.class}, CHEMICAL2, n)) {
            case 0 -> {
                Gas gas = (Gas)CHEMICAL2;
                yield new CrTChemicalStack.CrTGasStack(gas.getStack(size));
            }
            case 1 -> {
                InfuseType infuseType = (InfuseType)CHEMICAL2;
                yield new CrTChemicalStack.CrTInfusionStack(infuseType.getStack(size));
            }
            case 2 -> {
                Pigment pigment = (Pigment)CHEMICAL2;
                yield new CrTChemicalStack.CrTPigmentStack(pigment.getStack(size));
            }
            case 3 -> {
                Slurry slurry = (Slurry)CHEMICAL2;
                yield new CrTChemicalStack.CrTSlurryStack(slurry.getStack(size));
            }
            default -> throw new IllegalArgumentException("Unknown chemical type");
        });
    }

    public static ItemStackIngredient fromCrT(IIngredientWithAmount ingredient) {
        return IngredientCreatorAccess.item().from(ExpandIIngredientWithAmountNeoForge.asSizedIngredient((IIngredientWithAmount)ingredient));
    }

    public static IIngredientWithAmount toCrT(ItemStackIngredient ingredient) {
        return ExpandSizedIngredient.asIIngredientWithAmount((SizedIngredient)ingredient.ingredient());
    }

    public static FluidStackIngredient fromCrT(CTFluidIngredient ingredient) {
        return IngredientCreatorAccess.fluid().from(ExpandCTFluidIngredientNeoForge.asSizedFluidIngredient((CTFluidIngredient)ingredient));
    }

    public static CTFluidIngredient toCrT(FluidStackIngredient ingredient) {
        return ExpandSizedFluidIngredient.asCTFluidIngredient((SizedFluidIngredient)ingredient.ingredient());
    }

    public static <C> Optional<C> getSingleIfPresent(IDecomposedRecipe recipe, IRecipeComponent<C> component) {
        List values = recipe.get(component);
        if (values == null) {
            return Optional.empty();
        }
        if (values.size() != 1) {
            String message = String.format(Locale.ROOT, "Expected a list with a single element for %s, but got %d-sized list: %s", component.getCommandString(), values.size(), values);
            throw new IllegalArgumentException(message);
        }
        return Optional.of(values.getFirst());
    }

    public static <C> UnaryTypePair<C> getPair(IDecomposedRecipe recipe, IRecipeComponent<C> component) {
        List list = recipe.getOrThrow(component);
        if (list.size() != 2) {
            String message = String.format(Locale.ROOT, "Expected a list with two elements element for %s, but got %d-sized list: %s", component.getCommandString(), list.size(), list);
            throw new IllegalArgumentException(message);
        }
        return new UnaryTypePair(list.get(0), list.get(1));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> String describeOutputs(List<STACK> outputs) {
        if (outputs.isEmpty()) {
            return "";
        }
        return CrTUtils.describeOutputs(outputs, CrTUtils.getConverter((ChemicalStack)outputs.getFirst()));
    }

    public static <TYPE> String describeOutputs(List<TYPE> outputs, Function<TYPE, ?> converter) {
        int size = outputs.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return converter.apply(outputs.getFirst()).toString();
        }
        StringBuilder description = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                description.append(", or ");
            }
            description.append(converter.apply(outputs.get(i)));
        }
        return description.toString();
    }

    public static String describeOutputs(long[] outputs) {
        int size = outputs.length;
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return Long.toString(outputs[0]);
        }
        StringBuilder description = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                description.append(", or ");
            }
            description.append(outputs[i]);
        }
        return description.toString();
    }

    public static <TYPE> TagKey<TYPE> validateTagAndGet(KnownTag<TYPE> tag) {
        if (tag.exists()) {
            return tag.getTagKey();
        }
        throw new IllegalArgumentException("Tag " + tag.getCommandString() + " does not exist.");
    }

    public static <TYPE, CRT_TYPE> List<CRT_TYPE> convert(List<TYPE> elements, Function<TYPE, CRT_TYPE> converter) {
        return elements.stream().map(converter).toList();
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>> Function<STACK, CRT_STACK> getConverter(STACK stack) {
        return switch (ChemicalType.getTypeFor(stack)) {
            default -> throw new MatchException(null, null);
            case ChemicalType.GAS -> GAS_CONVERTER;
            case ChemicalType.INFUSION -> INFUSION_CONVERTER;
            case ChemicalType.PIGMENT -> PIGMENT_CONVERTER;
            case ChemicalType.SLURRY -> SLURRY_CONVERTER;
        };
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>> List<CRT_STACK> convertChemical(List<STACK> elements) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return CrTUtils.convert(elements, CrTUtils.getConverter((ChemicalStack)elements.getFirst()));
    }

    public static List<IItemStack> convertItems(List<ItemStack> elements) {
        return CrTUtils.convert(elements, IItemStack::of);
    }

    public static List<IFluidStack> convertFluids(List<FluidStack> elements) {
        return CrTUtils.convert(elements, IFluidStack::of);
    }

    public static KnownTagManager<Item> itemTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registries.ITEM);
    }

    public static KnownTagManager<Fluid> fluidTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registries.FLUID);
    }

    public static KnownTagManager<Gas> gasTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(MekanismAPI.GAS_REGISTRY_NAME);
    }

    public static KnownTagManager<InfuseType> infuseTypeTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(MekanismAPI.INFUSE_TYPE_REGISTRY_NAME);
    }

    public static KnownTagManager<Pigment> pigmentTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(MekanismAPI.PIGMENT_REGISTRY_NAME);
    }

    public static KnownTagManager<Slurry> slurryTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(MekanismAPI.SLURRY_REGISTRY_NAME);
    }

    public record UnaryTypePair<TYPE>(TYPE a, TYPE b) {
    }
}

