/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IGasIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import net.minecraft.tags.TagKey;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=GasStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ChemicalStackIngredient.GasStackIngredient")
public class CrTGasStackIngredient {
    private CrTGasStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(Gas instance, long amount) {
        CrTIngredientHelper.assertValid(instance, amount, "GasStackIngredients", "gas");
        return IngredientCreatorAccess.gasStack().from((IGasIngredient)((Object)instance), amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(ICrTChemicalStack.ICrTGasStack instance) {
        CrTIngredientHelper.assertValid(instance, "GasStackIngredients");
        return IngredientCreatorAccess.gasStack().from((GasStack)instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(long amount, Gas ... gases) {
        CrTIngredientHelper.assertMultiple(amount, "GasStackIngredients", "gas", gases);
        return IngredientCreatorAccess.gasStack().from(amount, gases);
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(long amount, ICrTChemicalStack.ICrTGasStack ... gases) {
        CrTIngredientHelper.assertMultiple(amount, "GasStackIngredients", "gas", gases);
        return IngredientCreatorAccess.gasStack().from(amount, gases);
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(ICrTChemicalStack.ICrTGasStack ... gases) {
        long amount = CrTIngredientHelper.assertMultiple("GasStackIngredients", "gas", gases);
        return IngredientCreatorAccess.gasStack().from(amount, gases);
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(KnownTag<Gas> gasTag, long amount) {
        TagKey<Gas> tag = CrTIngredientHelper.assertValidAndGet(gasTag, amount, "GasStackIngredients");
        return IngredientCreatorAccess.gasStack().from((IGasIngredient)tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static GasStackIngredient from(Many<KnownTag<Gas>> gasTag) {
        return CrTGasStackIngredient.from((KnownTag<Gas>)((KnownTag)gasTag.getData()), (long)gasTag.getAmount());
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(GasStackIngredient _this) {
        return (IData)IngredientCreatorAccess.gasStack().codec().encodeStart((DynamicOps)IDataOps.INSTANCE.withRegistryAccess(), (Object)_this).getOrThrow();
    }

    @ZenCodeType.Method
    public static boolean testType(GasStackIngredient _this, ICrTChemicalStack.ICrTGasStack type) {
        return _this.testType((GasStack)type.getInternal());
    }

    @ZenCodeType.Method
    public static boolean test(GasStackIngredient _this, ICrTChemicalStack.ICrTGasStack stack) {
        return _this.test((GasStack)stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="representations")
    public static List<ICrTChemicalStack.ICrTGasStack> getRepresentations(GasStackIngredient _this) {
        return CrTUtils.convertChemical(_this.getRepresentations());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static GasStackIngredient or(GasStackIngredient _this, GasStackIngredient other) {
        if (_this.amount() != other.amount()) {
            throw new IllegalArgumentException("GasStack ingredients can only be or'd if they have the same counts");
        }
        ArrayList ingredients = new ArrayList();
        CrTIngredientHelper.addIngredient(ingredients, (IGasIngredient)_this.ingredient());
        CrTIngredientHelper.addIngredient(ingredients, (IGasIngredient)other.ingredient());
        return IngredientCreatorAccess.gasStack().from(IngredientCreatorAccess.gas().ofIngredients(ingredients), _this.amount());
    }
}

