/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import java.util.List;
import mekanism.api.chemical.Chemical;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.chemical.CompoundChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.tags.TagKey;

public class CrTIngredientHelper {
    static void assertValidAmount(String ingredientType, long amount) {
        if (amount <= 0L) {
            throw new IllegalArgumentException(ingredientType + " can only be created with a size of at least one. Received size was: " + amount);
        }
    }

    static <TYPE> TagKey<TYPE> assertValidAndGet(KnownTag<TYPE> crtTag, long amount, String ingredientType) {
        CrTIngredientHelper.assertValidAmount(ingredientType, amount);
        return CrTUtils.validateTagAndGet(crtTag);
    }

    static void assertValid(Chemical<?> instance, long amount, String ingredientType, String chemicalType) {
        CrTIngredientHelper.assertValidAmount(ingredientType, amount);
        if (instance.isEmptyType()) {
            throw new IllegalArgumentException(ingredientType + " cannot be created from an empty " + chemicalType + ".");
        }
    }

    static void assertMultiple(long amount, String ingredientType, String chemicalType, IChemicalProvider<?> ... instances) {
        CrTIngredientHelper.assertValidAmount(ingredientType, amount);
        if (instances == null || instances.length == 0) {
            throw new IllegalArgumentException(ingredientType + " cannot be created from zero " + chemicalType + ".");
        }
        for (IChemicalProvider<?> instance : instances) {
            if (!((Chemical)instance.getChemical()).isEmptyType()) continue;
            throw new IllegalArgumentException(ingredientType + " cannot be created from an empty " + chemicalType + ".");
        }
    }

    static long assertMultiple(String ingredientType, String chemicalType, ICrTChemicalStack<?, ?, ?> ... instances) {
        if (instances == null || instances.length == 0) {
            throw new IllegalArgumentException(ingredientType + " cannot be created from zero " + chemicalType + ".");
        }
        long amount = 0L;
        for (ICrTChemicalStack<?, ?, ?> instance : instances) {
            if (instance.isEmpty()) {
                throw new IllegalArgumentException(ingredientType + " cannot be created from an empty " + chemicalType + ".");
            }
            if (amount != 0L) continue;
            amount = instance.getAmount();
        }
        CrTIngredientHelper.assertValidAmount(ingredientType, amount);
        return amount;
    }

    static void assertValid(ICrTChemicalStack<?, ?, ?> instance, String ingredientType) {
        if (instance.isEmpty()) {
            throw new IllegalArgumentException(ingredientType + " cannot be created from an empty stack.");
        }
    }

    static <INGREDIENT extends IChemicalIngredient<?, ?>> void addIngredient(List<INGREDIENT> ingredients, INGREDIENT ingredient) {
        if (ingredient instanceof CompoundChemicalIngredient) {
            CompoundChemicalIngredient compoundIngredient = (CompoundChemicalIngredient)ingredient;
            ingredients.addAll(compoundIngredient.children());
        } else {
            ingredients.add(ingredient);
        }
    }
}

