/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Optional;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.PigmentStackIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.handler.MekanismRecipeHandler;
import mekanism.common.integration.crafttweaker.recipe.manager.ChemicalChemicalToChemicalRecipeManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public abstract class ChemicalChemicalToChemicalRecipeHandler<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK, ?>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends MekanismRecipeHandler<RECIPE> {
    public String dumpToCommandString(IRecipeManager<? super RECIPE> manager, RegistryAccess registryAccess, RecipeHolder<RECIPE> recipeHolder) {
        ChemicalChemicalToChemicalRecipe recipe = (ChemicalChemicalToChemicalRecipe)recipeHolder.value();
        return this.buildCommandString(manager, recipeHolder, recipe.getLeftInput(), recipe.getRightInput(), recipe.getOutputDefinition());
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super RECIPE> manager, RECIPE recipe, U other) {
        if (this.recipeIsInstance(other)) {
            ChemicalChemicalToChemicalRecipe otherRecipe = (ChemicalChemicalToChemicalRecipe)other;
            return this.chemicalIngredientConflicts(((ChemicalChemicalToChemicalRecipe)recipe).getLeftInput(), (ChemicalStackIngredient<?, ?, ?>)otherRecipe.getLeftInput()) && this.chemicalIngredientConflicts(((ChemicalChemicalToChemicalRecipe)recipe).getRightInput(), (ChemicalStackIngredient<?, ?, ?>)otherRecipe.getRightInput()) || this.chemicalIngredientConflicts(((ChemicalChemicalToChemicalRecipe)recipe).getLeftInput(), (ChemicalStackIngredient<?, ?, ?>)otherRecipe.getRightInput()) && this.chemicalIngredientConflicts(((ChemicalChemicalToChemicalRecipe)recipe).getRightInput(), (ChemicalStackIngredient<?, ?, ?>)otherRecipe.getLeftInput());
        }
        return false;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super RECIPE> manager, RegistryAccess registryAccess, RECIPE recipe) {
        return this.decompose(((ChemicalChemicalToChemicalRecipe)recipe).getLeftInput(), ((ChemicalChemicalToChemicalRecipe)recipe).getRightInput(), ((ChemicalChemicalToChemicalRecipe)recipe).getOutputDefinition());
    }

    public Optional<RECIPE> recompose(IRecipeManager<? super RECIPE> m, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        if (m instanceof ChemicalChemicalToChemicalRecipeManager) {
            ChemicalChemicalToChemicalRecipeManager manager = (ChemicalChemicalToChemicalRecipeManager)m;
            CrTUtils.UnaryTypePair<INGREDIENT> inputs = CrTUtils.getPair(recipe, this.getChemicalComponent().input());
            return Optional.of(manager.makeRecipe((ChemicalStackIngredient)inputs.a(), (ChemicalStackIngredient)inputs.b(), (ICrTChemicalStack)recipe.getOrThrowSingle(this.getChemicalComponent().output())));
        }
        return Optional.empty();
    }

    protected abstract CrTRecipeComponents.ChemicalRecipeComponent<CHEMICAL, STACK, INGREDIENT, CRT_STACK> getChemicalComponent();

    protected abstract boolean recipeIsInstance(Recipe<?> var1);

    @IRecipeHandler.For(value=PigmentMixingRecipe.class)
    public static class PigmentMixingRecipeHandler
    extends ChemicalChemicalToChemicalRecipeHandler<Pigment, PigmentStack, PigmentStackIngredient, ICrTChemicalStack.ICrTPigmentStack, PigmentMixingRecipe> {
        @Override
        protected CrTRecipeComponents.ChemicalRecipeComponent<Pigment, PigmentStack, PigmentStackIngredient, ICrTChemicalStack.ICrTPigmentStack> getChemicalComponent() {
            return CrTRecipeComponents.PIGMENT;
        }

        @Override
        protected boolean recipeIsInstance(Recipe<?> other) {
            return other instanceof PigmentMixingRecipe;
        }
    }

    @IRecipeHandler.For(value=ChemicalInfuserRecipe.class)
    public static class ChemicalInfuserRecipeHandler
    extends ChemicalChemicalToChemicalRecipeHandler<Gas, GasStack, GasStackIngredient, ICrTChemicalStack.ICrTGasStack, ChemicalInfuserRecipe> {
        @Override
        protected CrTRecipeComponents.ChemicalRecipeComponent<Gas, GasStack, GasStackIngredient, ICrTChemicalStack.ICrTGasStack> getChemicalComponent() {
            return CrTRecipeComponents.GAS;
        }

        @Override
        protected boolean recipeIsInstance(Recipe<?> other) {
            return other instanceof ChemicalInfuserRecipe;
        }
    }
}

