/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.List;
import java.util.Optional;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.handler.MekanismRecipeHandler;
import mekanism.common.integration.crafttweaker.recipe.manager.PressurizedReactionRecipeManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

@IRecipeHandler.For(value=PressurizedReactionRecipe.class)
public class PressurizedReactionRecipeHandler
extends MekanismRecipeHandler<PressurizedReactionRecipe> {
    public String dumpToCommandString(IRecipeManager<? super PressurizedReactionRecipe> manager, RegistryAccess registryAccess, RecipeHolder<PressurizedReactionRecipe> recipeHolder) {
        GasStack gasOutput;
        ItemStack itemOutput;
        PressurizedReactionRecipe recipe = (PressurizedReactionRecipe)recipeHolder.value();
        List<PressurizedReactionRecipe.PressurizedReactionRecipeOutput> outputs = recipe.getOutputDefinition();
        if (outputs.isEmpty()) {
            itemOutput = ItemStack.EMPTY;
            gasOutput = GasStack.EMPTY;
        } else {
            PressurizedReactionRecipe.PressurizedReactionRecipeOutput output = outputs.getFirst();
            itemOutput = output.item();
            gasOutput = output.gas();
        }
        return this.buildCommandString(manager, recipeHolder, recipe.getInputSolid(), recipe.getInputFluid(), recipe.getInputGas(), recipe.getDuration(), itemOutput.isEmpty() ? SKIP_OPTIONAL_PARAM : itemOutput, gasOutput.isEmpty() ? SKIP_OPTIONAL_PARAM : gasOutput, recipe.getEnergyRequired() == 0L ? SKIP_OPTIONAL_PARAM : Long.valueOf(recipe.getEnergyRequired()));
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super PressurizedReactionRecipe> manager, PressurizedReactionRecipe recipe, U o) {
        if (o instanceof PressurizedReactionRecipe) {
            PressurizedReactionRecipe other = (PressurizedReactionRecipe)o;
            return this.ingredientConflicts(recipe.getInputSolid(), other.getInputSolid()) && this.ingredientConflicts(recipe.getInputFluid(), other.getInputFluid()) && this.ingredientConflicts(recipe.getInputGas(), other.getInputGas());
        }
        return false;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super PressurizedReactionRecipe> manager, RegistryAccess registryAccess, PressurizedReactionRecipe recipe) {
        return this.decompose(recipe.getInputSolid(), recipe.getInputFluid(), recipe.getInputGas(), recipe.getDuration(), recipe.getOutputDefinition(), recipe.getEnergyRequired());
    }

    public Optional<PressurizedReactionRecipe> recompose(IRecipeManager<? super PressurizedReactionRecipe> m, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        if (m instanceof PressurizedReactionRecipeManager) {
            GasStack outputGas;
            ItemStack outputItem;
            PressurizedReactionRecipeManager manager = (PressurizedReactionRecipeManager)m;
            Optional<IItemStack> optionalOutputItem = CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.ITEM.output());
            if (optionalOutputItem.isPresent()) {
                outputItem = optionalOutputItem.get().getImmutableInternal();
                outputGas = CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.GAS.output()).map(ICrTChemicalStack::getImmutableInternal).orElse(GasStack.EMPTY);
            } else {
                outputItem = ItemStack.EMPTY;
                outputGas = (GasStack)((ICrTChemicalStack.ICrTGasStack)recipe.getOrThrowSingle(CrTRecipeComponents.GAS.output())).getImmutableInternal();
            }
            return Optional.of(manager.makeRecipe((IIngredientWithAmount)recipe.getOrThrowSingle(CrTRecipeComponents.ITEM.input()), (CTFluidIngredient)recipe.getOrThrowSingle(CrTRecipeComponents.FLUID.input()), (GasStackIngredient)recipe.getOrThrowSingle(CrTRecipeComponents.GAS.input()), (Integer)recipe.getOrThrowSingle(BuiltinRecipeComponents.Processing.TIME), outputItem, outputGas, CrTUtils.getSingleIfPresent(recipe, CrTRecipeComponents.ENERGY).orElse(0L)));
        }
        return Optional.empty();
    }
}

