/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.basic.BasicElectrolysisRecipe;
import mekanism.api.recipes.vanilla_input.SingleFluidRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Separating")
public class ElectrolysisRecipeManager
extends MekanismRecipeManager<SingleFluidRecipeInput, ElectrolysisRecipe> {
    public static final ElectrolysisRecipeManager INSTANCE = new ElectrolysisRecipeManager();

    private ElectrolysisRecipeManager() {
        super(MekanismRecipeType.SEPARATING);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput, long energyMultiplier) {
        this.addRecipe(name, this.makeRecipe(input, leftGasOutput, rightGasOutput, energyMultiplier));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput) {
        this.addRecipe(name, this.makeRecipe(input, leftGasOutput, rightGasOutput, 1L));
    }

    public final ElectrolysisRecipe makeRecipe(CTFluidIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput, long energyMultiplier) {
        if (energyMultiplier < 1L) {
            throw new IllegalArgumentException("Energy multiplier must be at least one! Multiplier: " + energyMultiplier);
        }
        return new BasicElectrolysisRecipe(CrTUtils.fromCrT(input), energyMultiplier, this.getAndValidateNotEmpty(leftGasOutput), this.getAndValidateNotEmpty(rightGasOutput));
    }

    @Override
    protected String describeOutputs(ElectrolysisRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), output -> String.valueOf(new CrTChemicalStack.CrTGasStack(output.left())) + " and " + String.valueOf(new CrTChemicalStack.CrTGasStack(output.right())));
    }
}

