/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.curios;

import java.util.Optional;
import java.util.function.Predicate;
import mekanism.client.render.MekanismCurioRenderer;
import mekanism.client.render.armor.ICustomArmor;
import mekanism.client.render.armor.ISpecialGear;
import mekanism.common.Mekanism;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.RegistryUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosIntegration {
    public static void addListeners(IEventBus bus) {
        bus.addListener(event -> CuriosIntegration.registerRenderers(MekanismItems.JETPACK, MekanismItems.ARMORED_JETPACK));
    }

    private static void registerRenderers(ItemLike ... items) {
        for (ItemLike item : items) {
            ArmorItem armor;
            Item item2 = item.asItem();
            if (item2 instanceof ArmorItem && (item2 = IClientItemExtensions.of((Item)(armor = (ArmorItem)item2))) instanceof ISpecialGear) {
                ISpecialGear gear = (ISpecialGear)item2;
                ICustomArmor customArmor = gear.gearModel();
                CuriosRendererRegistry.register((Item)armor, () -> new MekanismCurioRenderer(customArmor));
                continue;
            }
            Mekanism.logger.warn("Attempted to register Curios renderer for non-special gear item: {}.", (Object)RegistryUtils.getName(item.asItem()));
        }
    }

    @Nullable
    public static IItemHandler getCuriosInventory(LivingEntity entity) {
        return (IItemHandler)entity.getCapability(CuriosCapability.ITEM_HANDLER);
    }

    public static Optional<SlotResult> findFirstCurioAsResult(@NotNull LivingEntity entity, Predicate<ItemStack> filter) {
        ICuriosItemHandler capability = (ICuriosItemHandler)entity.getCapability(CuriosCapability.INVENTORY);
        if (capability == null) {
            return Optional.empty();
        }
        return capability.findFirstCurio(filter);
    }

    public static ItemStack findFirstCurio(@NotNull LivingEntity entity, Predicate<ItemStack> filter) {
        return CuriosIntegration.findFirstCurioAsResult(entity, filter).map(SlotResult::stack).orElse(ItemStack.EMPTY);
    }

    public static ItemStack getCurioStack(@NotNull LivingEntity entity, String slotType, int slot) {
        ICuriosItemHandler capability = (ICuriosItemHandler)entity.getCapability(CuriosCapability.INVENTORY);
        if (capability == null) {
            return ItemStack.EMPTY;
        }
        Optional stacksHandler = capability.getStacksHandler(slotType);
        if (stacksHandler.isPresent()) {
            return ((ICurioStacksHandler)stacksHandler.get()).getStacks().getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }
}

