/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.fluxnetworks;

import mekanism.api.Action;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.util.UnitDisplayUtils;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

public class FNIntegration
implements IFNEnergyStorage {
    private final IStrictEnergyHandler handler;

    public FNIntegration(IStrictEnergyHandler handler) {
        this.handler = handler;
    }

    public long receiveEnergyL(long maxReceive, boolean simulate) {
        long remainder;
        if (maxReceive <= 0L) {
            return 0L;
        }
        Action action = Action.get(!simulate);
        long toInsert = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(maxReceive);
        if (toInsert == 0L) {
            return 0L;
        }
        if (!UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.isOneToOne()) {
            long simulatedRemainder = this.handler.insertEnergy(toInsert, Action.SIMULATE);
            if (simulatedRemainder == toInsert) {
                return 0L;
            }
            long simulatedInserted = toInsert - simulatedRemainder;
            if ((toInsert = this.convertToAndBack(simulatedInserted)) == 0L) {
                return 0L;
            }
        }
        if ((remainder = this.handler.insertEnergy(toInsert, action)) == toInsert) {
            return 0L;
        }
        long inserted = toInsert - remainder;
        return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(inserted);
    }

    public long extractEnergyL(long maxExtract, boolean simulate) {
        long simulatedExtracted;
        if (maxExtract <= 0L) {
            return 0L;
        }
        Action action = Action.get(!simulate);
        long toExtract = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(maxExtract);
        if (toExtract == 0L) {
            return 0L;
        }
        if (!UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.isOneToOne() && (toExtract = this.convertToAndBack(simulatedExtracted = this.handler.extractEnergy(toExtract, Action.SIMULATE))) == 0L) {
            return 0L;
        }
        long extracted = this.handler.extractEnergy(toExtract, action);
        return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(extracted);
    }

    private long convertToAndBack(long joules) {
        long fe = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(joules);
        long result = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(fe);
        if (UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.getConversion() >= 1.0 && (double)result % UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.getConversion() > 0.0) {
            return UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertFrom(fe - 1L);
        }
        return result;
    }

    public long getEnergyStoredL() {
        long energy = 0L;
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            long total = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(this.handler.getEnergy(container));
            if (total > Long.MAX_VALUE - energy) {
                return Long.MAX_VALUE;
            }
            energy += total;
        }
        return energy;
    }

    public long getMaxEnergyStoredL() {
        long maxEnergy = 0L;
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            long max = UnitDisplayUtils.EnergyUnit.FORGE_ENERGY.convertTo(this.handler.getMaxEnergy(container));
            if (max > Long.MAX_VALUE - maxEnergy) {
                return Long.MAX_VALUE;
            }
            maxEnergy += max;
        }
        return maxEnergy;
    }

    public boolean canExtract() {
        if (this.handler.extractEnergy(1L, Action.SIMULATE) != 0L) {
            return true;
        }
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            if (this.handler.getEnergy(container) <= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean canReceive() {
        if (this.handler.insertEnergy(1L, Action.SIMULATE) == 0L) {
            return true;
        }
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            if (this.handler.getNeededEnergy(container) <= 0L) continue;
            return false;
        }
        return true;
    }
}

