/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.forgeenergy;

import mekanism.api.Action;
import mekanism.api.energy.IEnergyConversion;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.util.UnitDisplayUtils;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.VisibleForTesting;

public class ForgeEnergyIntegration
implements IEnergyStorage {
    private final IStrictEnergyHandler handler;
    private final IEnergyConversion converter;

    public ForgeEnergyIntegration(IStrictEnergyHandler handler) {
        this(handler, UnitDisplayUtils.EnergyUnit.FORGE_ENERGY);
    }

    @VisibleForTesting
    ForgeEnergyIntegration(IStrictEnergyHandler handler, IEnergyConversion converter) {
        this.handler = handler;
        this.converter = converter;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long remainder;
        if (maxReceive <= 0) {
            return 0;
        }
        Action action = Action.get(!simulate);
        long toInsert = this.converter.convertFrom(maxReceive);
        if (toInsert == 0L) {
            return 0;
        }
        if (!this.converter.isOneToOne()) {
            long simulatedRemainder = this.handler.insertEnergy(toInsert, Action.SIMULATE);
            if (simulatedRemainder == toInsert) {
                return 0;
            }
            long simulatedInserted = toInsert - simulatedRemainder;
            if ((toInsert = this.convertToAndBack(simulatedInserted)) == 0L) {
                return 0;
            }
        }
        if ((remainder = this.handler.insertEnergy(toInsert, action)) == toInsert) {
            return 0;
        }
        long inserted = toInsert - remainder;
        return this.converter.convertToAsInt(inserted);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        long simulatedExtracted;
        if (maxExtract <= 0) {
            return 0;
        }
        Action action = Action.get(!simulate);
        long toExtract = this.converter.convertFrom(maxExtract);
        if (toExtract == 0L) {
            return 0;
        }
        if (!this.converter.isOneToOne() && (toExtract = this.convertToAndBack(simulatedExtracted = this.handler.extractEnergy(toExtract, Action.SIMULATE))) == 0L) {
            return 0;
        }
        long extracted = this.handler.extractEnergy(toExtract, action);
        return this.converter.convertToAsInt(extracted);
    }

    private long convertToAndBack(long joules) {
        int fe = this.converter.convertToAsInt(joules);
        long result = this.converter.convertFrom(fe);
        if (this.converter.getConversion() >= 1.0 && (double)result % this.converter.getConversion() > 0.0) {
            return this.converter.convertFrom(fe - 1);
        }
        return result;
    }

    public int getEnergyStored() {
        int energy = 0;
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            int total = this.converter.convertToAsInt(this.handler.getEnergy(container));
            if (total > Integer.MAX_VALUE - energy) {
                return Integer.MAX_VALUE;
            }
            energy += total;
        }
        return energy;
    }

    public int getMaxEnergyStored() {
        int maxEnergy = 0;
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            int max = this.converter.convertToAsInt(this.handler.getMaxEnergy(container));
            if (max > Integer.MAX_VALUE - maxEnergy) {
                return Integer.MAX_VALUE;
            }
            maxEnergy += max;
        }
        return maxEnergy;
    }

    public boolean canExtract() {
        if (this.handler.extractEnergy(1L, Action.SIMULATE) != 0L) {
            return true;
        }
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            if (this.handler.getEnergy(container) <= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean canReceive() {
        if (this.handler.insertEnergy(1L, Action.SIMULATE) == 0L) {
            return true;
        }
        int containers = this.handler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            if (this.handler.getNeededEnergy(container) <= 0L) continue;
            return false;
        }
        return true;
    }
}

