/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.providers.IPigmentProvider;
import moze_intel.projecte.api.codec.NSSCodecHolder;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public final class NSSPigment
extends AbstractNSSTag<Pigment> {
    private static final boolean ALLOW_DEFAULT = false;
    public static final Codec<NSSPigment> LEGACY_CODEC = NSSPigment.createLegacyCodec(MekanismAPI.PIGMENT_REGISTRY, (boolean)false, (String)"PIGMENT|", NSSPigment::new);
    public static final MapCodec<NSSPigment> EXPLICIT_MAP_CODEC = NSSPigment.createExplicitCodec(MekanismAPI.PIGMENT_REGISTRY, (boolean)false, NSSPigment::new);
    public static final Codec<NSSPigment> EXPLICIT_CODEC = EXPLICIT_MAP_CODEC.codec();
    public static final NSSCodecHolder<NSSPigment> CODECS = new NSSCodecHolder("PIGMENT", LEGACY_CODEC, EXPLICIT_CODEC);

    private NSSPigment(@NotNull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @NotNull
    public static NSSPigment createPigment(@NotNull PigmentStack stack) {
        return NSSPigment.createPigment((Pigment)stack.getChemical());
    }

    @NotNull
    public static NSSPigment createPigment(@NotNull IPigmentProvider pigmentProvider) {
        return NSSPigment.createPigment((Pigment)pigmentProvider.getChemical());
    }

    @NotNull
    public static NSSPigment createPigment(@NotNull Pigment pigment) {
        if (pigment.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSPigment with an empty pigment");
        }
        return NSSPigment.createPigment(pigment.getRegistryName());
    }

    @NotNull
    public static NSSPigment createPigment(@NotNull ResourceLocation pigmentID) {
        return new NSSPigment(pigmentID, false);
    }

    @NotNull
    public static NSSPigment createTag(@NotNull ResourceLocation tagId) {
        return new NSSPigment(tagId, true);
    }

    @NotNull
    public static NSSPigment createTag(@NotNull TagKey<Pigment> tag) {
        return NSSPigment.createTag(tag.location());
    }

    @NotNull
    protected Registry<Pigment> getRegistry() {
        return MekanismAPI.PIGMENT_REGISTRY;
    }

    protected NSSPigment createNew(Pigment pigment) {
        return NSSPigment.createPigment(pigment);
    }

    public NSSCodecHolder<NSSPigment> codecs() {
        return CODECS;
    }
}

