/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;

@RecipeTypeMapper
public class ItemStackToInfuseTypeRecipeMapper
extends TypedMekanismRecipeMapper<ItemStackToInfuseTypeRecipe> {
    public ItemStackToInfuseTypeRecipeMapper() {
        super(ItemStackToInfuseTypeRecipe.class, MekanismRecipeType.INFUSION_CONVERSION);
    }

    public String getName() {
        return "MekItemStackToInfuseType";
    }

    public String getDescription() {
        return "Maps Mekanism item stack to infuse type conversion recipes.";
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, ItemStackToInfuseTypeRecipe recipe) {
        boolean handled = false;
        for (ItemStack representation : recipe.getInput().getRepresentations()) {
            InfusionStack output = recipe.getOutput(representation);
            if (output.isEmpty()) continue;
            IngredientHelper ingredientHelper = new IngredientHelper(mapper);
            ingredientHelper.put(representation);
            if (!ingredientHelper.addAsConversion(output)) continue;
            handled = true;
        }
        return handled;
    }
}

