/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.neoforged.neoforge.fluids.FluidStack;

@RecipeTypeMapper
public class RotaryRecipeMapper
extends TypedMekanismRecipeMapper<RotaryRecipe> {
    public RotaryRecipeMapper() {
        super(RotaryRecipe.class, MekanismRecipeType.ROTARY);
    }

    public String getName() {
        return "MekRotary";
    }

    public String getDescription() {
        return "Maps Mekanism rotary condensentrator recipes.";
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, RotaryRecipe recipe) {
        IngredientHelper ingredientHelper;
        GasStack output;
        boolean handled = false;
        if (recipe.hasFluidToGas()) {
            for (Object representation : recipe.getFluidInput().getRepresentations()) {
                output = recipe.getGasOutput((FluidStack)representation);
                if (output.isEmpty()) continue;
                ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((FluidStack)representation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        if (recipe.hasGasToFluid()) {
            for (Object representation : recipe.getGasInput().getRepresentations()) {
                output = recipe.getFluidOutput((GasStack)representation);
                if (output.isEmpty()) continue;
                ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((ChemicalStack<?>)representation);
                if (!ingredientHelper.addAsConversion((FluidStack)output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

