/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.chemical;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IEmptyStackProvider;
import mekanism.common.inventory.container.sync.ISyncableData;
import org.jetbrains.annotations.NotNull;

public abstract class SyncableChemicalStack<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements ISyncableData,
IEmptyStackProvider<CHEMICAL, STACK> {
    @NotNull
    private ChemicalStack<CHEMICAL> lastKnownValue;
    private final Supplier<@NotNull STACK> getter;
    private final Consumer<@NotNull STACK> setter;

    protected SyncableChemicalStack(Supplier<@NotNull STACK> getter, Consumer<@NotNull STACK> setter) {
        this.getter = getter;
        this.setter = setter;
        this.lastKnownValue = this.getEmptyStack();
    }

    @NotNull
    protected STACK createStack(STACK stored, long size) {
        return (STACK)((ChemicalStack)stored).copyWithAmount(size);
    }

    @NotNull
    public STACK get() {
        return (STACK)((ChemicalStack)this.getter.get());
    }

    public void set(@NotNull STACK value) {
        this.setter.accept(value);
    }

    public void set(long amount) {
        STACK stack = this.get();
        if (!((ChemicalStack)stack).isEmpty()) {
            this.set(this.createStack(stack, amount));
        }
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        STACK value = this.get();
        boolean sameType = ChemicalStack.isSameChemical(value, this.lastKnownValue);
        if (!sameType || ((ChemicalStack)value).getAmount() != this.lastKnownValue.getAmount()) {
            this.lastKnownValue = ((ChemicalStack)value).copy();
            return sameType ? ISyncableData.DirtyType.SIZE : ISyncableData.DirtyType.DIRTY;
        }
        return ISyncableData.DirtyType.CLEAN;
    }
}

