/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.item.ComponentBackedBinInventorySlot;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.tier.BinTier;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BinInventorySlot
extends BasicInventorySlot {
    public static final Predicate<@NotNull ItemStack> validator = stack -> !(stack.getItem() instanceof ItemBlockBin);
    private final boolean isCreative;
    private ItemStack lockStack = ItemStack.EMPTY;

    @Nullable
    public static ComponentBackedBinInventorySlot getForStack(@NotNull ItemStack stack) {
        IInventorySlot slot;
        List<IInventorySlot> slots;
        IMekanismInventory attachment;
        if (!stack.isEmpty() && stack.getItem() instanceof ItemBlockBin && (attachment = (IMekanismInventory)ContainerType.ITEM.createHandler(stack)) != null && (slots = attachment.getInventorySlots(null)).size() == 1 && (slot = slots.getFirst()) instanceof ComponentBackedBinInventorySlot) {
            ComponentBackedBinInventorySlot binSlot = (ComponentBackedBinInventorySlot)slot;
            return binSlot;
        }
        return null;
    }

    public static BinInventorySlot create(@Nullable IContentsListener listener, BinTier tier) {
        Objects.requireNonNull(tier, "Bin tier cannot be null");
        return new BinInventorySlot(listener, tier);
    }

    private BinInventorySlot(@Nullable IContentsListener listener, BinTier tier) {
        super(tier.getStorage(), alwaysTrueBi, alwaysTrueBi, validator, listener, 0, 0);
        this.isCreative = tier == BinTier.CREATIVE;
        this.obeyStackLimit = false;
    }

    @Override
    public ItemStack insertItem(ItemStack stack, Action action, AutomationType automationType) {
        if (this.isEmpty()) {
            if (this.isLocked() && !ItemStack.isSameItemSameComponents((ItemStack)this.lockStack, (ItemStack)stack)) {
                return stack;
            }
            if (this.isCreative && action.execute() && automationType != AutomationType.EXTERNAL) {
                ItemStack simulatedRemainder = super.insertItem(stack, Action.SIMULATE, automationType);
                if (simulatedRemainder.isEmpty()) {
                    this.setStackUnchecked(stack.copyWithCount(this.getLimit(stack)));
                }
                return simulatedRemainder;
            }
        }
        return super.insertItem(stack, action.combine(!this.isCreative), automationType);
    }

    @Override
    public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        return super.extractItem(amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public int setStackSize(int amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }

    @Override
    @Nullable
    public InventoryContainerSlot createContainerSlot() {
        return null;
    }

    public ItemStack getBottomStack() {
        if (this.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.current.copyWithCount(Math.min(this.getCount(), this.current.getMaxStackSize()));
    }

    public boolean setLocked(boolean lock) {
        if (this.isCreative || this.isLocked() == lock || lock && this.isEmpty()) {
            return false;
        }
        this.lockStack = lock ? this.current.copyWithCount(1) : ItemStack.EMPTY;
        return true;
    }

    public void setLockStack(@NotNull ItemStack stack) {
        this.lockStack = stack.copyWithCount(1);
    }

    public boolean isLocked() {
        return !this.lockStack.isEmpty();
    }

    public ItemStack getRenderStack() {
        return this.isLocked() ? this.getLockStack() : this.getStack();
    }

    public ItemStack getLockStack() {
        return this.lockStack;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        if (this.isLocked()) {
            nbt.put("lock_stack", this.lockStack.save(provider));
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        NBTUtils.setItemStackOrEmpty(provider, nbt, "lock_stack", s -> {
            this.lockStack = s;
        });
        super.deserializeNBT(provider, nbt);
    }
}

