/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class CraftingWindowInventorySlot
extends BasicInventorySlot {
    protected final QIOCraftingWindow craftingWindow;
    @Nullable
    private final IContentsListener inputTypeChange;
    private ItemStack lastCurrent = ItemStack.EMPTY;
    private boolean wasEmpty = true;

    public static CraftingWindowInventorySlot input(QIOCraftingWindow window, @Nullable IContentsListener saveListener) {
        return new CraftingWindowInventorySlot(notExternal, alwaysTrueBi, window, saveListener, window);
    }

    protected CraftingWindowInventorySlot(BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, QIOCraftingWindow craftingWindow, @Nullable IContentsListener saveListener, @Nullable IContentsListener inputTypeChange) {
        super(canExtract, canInsert, (Predicate<ItemStack>)alwaysTrue, saveListener, 0, 0);
        this.craftingWindow = craftingWindow;
        this.inputTypeChange = inputTypeChange;
    }

    @Override
    @NotNull
    public VirtualInventoryContainerSlot createContainerSlot() {
        return new VirtualInventoryContainerSlot(this, this.craftingWindow.getWindowData(), this.getSlotOverlay(), this::setStackUnchecked);
    }

    @Override
    public void onContentsChanged() {
        super.onContentsChanged();
        if (this.inputTypeChange != null && (this.current.isEmpty() != this.wasEmpty || this.current != this.lastCurrent && !ItemStack.isSameItemSameComponents((ItemStack)this.current, (ItemStack)this.lastCurrent))) {
            this.lastCurrent = this.current;
            this.wasEmpty = this.current.isEmpty();
            this.inputTypeChange.onContentsChanged();
        }
    }
}

