/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.content.qio.IQIODriveHolder;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class QIODriveSlot
extends BasicInventorySlot {
    public static final Predicate<ItemStack> IS_QIO_ITEM = stack -> stack.getItem() instanceof IQIODriveItem;
    private final Supplier<@Nullable Level> levelSupplier;
    private final IQIODriveHolder driveHolder;
    private final QIODriveData.QIODriveKey key;

    public QIODriveSlot(IQIODriveHolder driveHolder, int slot, Supplier<@Nullable Level> levelSupplier, @Nullable IContentsListener listener, int x, int y) {
        super(notExternal, notExternal, IS_QIO_ITEM, listener, x, y);
        this.driveHolder = driveHolder;
        this.levelSupplier = levelSupplier;
        this.key = new QIODriveData.QIODriveKey(this.driveHolder, slot);
    }

    @Override
    public void setStack(ItemStack stack) {
        if (!this.isRemote() && !this.isEmpty()) {
            this.removeDrive();
        }
        super.setStack(stack);
        if (!this.isRemote() && !this.isEmpty()) {
            this.addDrive(this.getStack());
        }
    }

    @Override
    public void setStackUnchecked(ItemStack stack) {
        if (!this.isRemote() && !this.isEmpty()) {
            this.removeDrive();
        }
        super.setStackUnchecked(stack);
        if (!this.isRemote() && !this.isEmpty()) {
            this.addDrive(this.getStack());
        }
    }

    @Override
    public ItemStack insertItem(ItemStack stack, Action action, AutomationType automationType) {
        ItemStack ret = super.insertItem(stack, action, automationType);
        if (!this.isRemote() && action.execute() && ret.isEmpty()) {
            this.addDrive(stack);
        }
        return ret;
    }

    @Override
    public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        ItemStack ret;
        if (!this.isRemote() && action.execute() && !(ret = super.extractItem(amount, Action.SIMULATE, automationType)).isEmpty()) {
            this.removeDrive();
        }
        return super.extractItem(amount, action, automationType);
    }

    public QIODriveData.QIODriveKey getKey() {
        return this.key;
    }

    private boolean isRemote() {
        Level level = this.levelSupplier.get();
        return level == null || level.isClientSide();
    }

    private void addDrive(ItemStack stack) {
        QIOFrequency frequency = this.driveHolder.getQIOFrequency();
        if (frequency != null) {
            frequency.addDrive(this.key);
        }
    }

    private void removeDrive() {
        QIOFrequency frequency = this.driveHolder.getQIOFrequency();
        if (frequency != null) {
            frequency.removeDrive(this.key, true);
        }
    }
}

