/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot.chemical;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.common.capabilities.MultiTypeCapability;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class ChemicalInventorySlot<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends BasicInventorySlot {
    protected final Supplier<Level> worldSupplier;
    protected final IChemicalTank<CHEMICAL, STACK> chemicalTank;

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>> STACK getPotentialConversion(IMekanismRecipeTypeProvider<?, RECIPE, InputRecipeCache.SingleItem<RECIPE>> recipeType, @Nullable Level world, ItemStack itemStack, STACK empty) {
        ItemStackToChemicalRecipe foundRecipe = (ItemStackToChemicalRecipe)recipeType.getInputCache().findTypeBasedRecipe(world, itemStack);
        return foundRecipe == null ? empty : foundRecipe.getOutput(itemStack);
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NotNull ItemStack> getFillOrConvertExtractPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, MultiTypeCapability<? extends IChemicalHandler<CHEMICAL, STACK>> chemicalCapability, Function<ItemStack, STACK> potentialConversionSupplier) {
        return stack -> {
            ChemicalStack conversion;
            IChemicalHandler handler = (IChemicalHandler)chemicalCapability.getCapability((ItemStack)stack);
            if (handler != null) {
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    if (!chemicalTank.isValid(handler.getChemicalInTank(tank))) continue;
                    return false;
                }
            }
            return (conversion = (ChemicalStack)potentialConversionSupplier.apply((ItemStack)stack)).isEmpty() || !chemicalTank.isValid(conversion);
        };
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NotNull ItemStack> getFillOrConvertInsertPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, MultiTypeCapability<? extends IChemicalHandler<CHEMICAL, STACK>> chemicalCapability, Function<ItemStack, STACK> potentialConversionSupplier) {
        return stack -> {
            if (ChemicalInventorySlot.fillInsertCheck(chemicalTank, chemicalCapability, stack)) {
                return true;
            }
            ChemicalStack conversion = (ChemicalStack)potentialConversionSupplier.apply((ItemStack)stack);
            if (conversion.isEmpty()) {
                return false;
            }
            if (chemicalTank.insert(conversion, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < conversion.getAmount()) {
                return true;
            }
            return chemicalTank.getNeeded() == 0L && chemicalTank.isTypeEqual((Object)conversion) && chemicalTank.isValid(conversion);
        };
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NotNull ItemStack> getFillExtractPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, MultiTypeCapability<? extends IChemicalHandler<CHEMICAL, STACK>> chemicalCapability) {
        return stack -> {
            IChemicalHandler handler = (IChemicalHandler)chemicalCapability.getCapability((ItemStack)stack);
            if (handler != null) {
                for (int tank = 0; tank < handler.getTanks(); ++tank) {
                    Object storedChemical = handler.getChemicalInTank(tank);
                    if (((ChemicalStack)storedChemical).isEmpty() || !chemicalTank.isValid(storedChemical)) continue;
                    return false;
                }
            }
            return true;
        };
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean fillInsertCheck(IChemicalTank<CHEMICAL, STACK> chemicalTank, MultiTypeCapability<? extends IChemicalHandler<CHEMICAL, STACK>> chemicalCapability, ItemStack stack) {
        IChemicalHandler handler = (IChemicalHandler)chemicalCapability.getCapability(stack);
        if (handler != null) {
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                Object chemicalInTank = handler.getChemicalInTank(tank);
                if (((ChemicalStack)chemicalInTank).isEmpty() || ((ChemicalStack)chemicalTank.insert(chemicalInTank, Action.SIMULATE, AutomationType.INTERNAL)).getAmount() >= ((ChemicalStack)chemicalInTank).getAmount()) continue;
                return true;
            }
        }
        return false;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NotNull ItemStack> getDrainInsertPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, MultiTypeCapability<? extends IChemicalHandler<CHEMICAL, STACK>> chemicalCapability) {
        return stack -> {
            IChemicalHandler handler = (IChemicalHandler)chemicalCapability.getCapability((ItemStack)stack);
            if (handler != null) {
                if (chemicalTank.isEmpty()) {
                    for (int tank = 0; tank < handler.getTanks(); ++tank) {
                        if (((ChemicalStack)handler.getChemicalInTank(tank)).getAmount() >= handler.getTankCapacity(tank)) continue;
                        return true;
                    }
                    return false;
                }
                return ((ChemicalStack)handler.insertChemical(chemicalTank.getStack(), Action.SIMULATE)).getAmount() < chemicalTank.getStored();
            }
            return false;
        };
    }

    protected ChemicalInventorySlot(IChemicalTank<CHEMICAL, STACK> chemicalTank, Supplier<Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        this(chemicalTank, worldSupplier, canExtract, canInsert, alwaysTrue, listener, x, y);
    }

    protected ChemicalInventorySlot(IChemicalTank<CHEMICAL, STACK> chemicalTank, Supplier<Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.setSlotType(ContainerSlotType.EXTRA);
        this.chemicalTank = chemicalTank;
        this.worldSupplier = worldSupplier;
    }

    @Nullable
    protected IChemicalHandler<CHEMICAL, STACK> getCapability() {
        return (IChemicalHandler)this.getChemicalCapability().getCapability(this.current);
    }

    protected abstract MultiTypeCapability<? extends IChemicalHandler<CHEMICAL, STACK>> getChemicalCapability();

    @Nullable
    protected ItemStackToChemicalRecipe<CHEMICAL, STACK> getConversionRecipe(@Nullable Level world, ItemStack stack) {
        return null;
    }

    public void fillTankOrConvert() {
        STACK output;
        ItemStack itemInput;
        ItemStackToChemicalRecipe<CHEMICAL, STACK> foundRecipe;
        if (!(this.isEmpty() || this.chemicalTank.getNeeded() <= 0L || ChemicalInventorySlot.fillChemicalTankFromItem(this, this.chemicalTank, this.getCapability()) || (foundRecipe = this.getConversionRecipe(this.worldSupplier.get(), this.current)) == null || (itemInput = foundRecipe.getInput().getMatchingInstance(this.current)).isEmpty() || ((ChemicalStack)(output = foundRecipe.getOutput(itemInput))).isEmpty() || !((ChemicalStack)this.chemicalTank.insert(output, Action.SIMULATE, AutomationType.MANUAL)).isEmpty())) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)this.chemicalTank.insert(output, Action.EXECUTE, AutomationType.MANUAL)).getAmount(), 0L);
            int amountUsed = itemInput.getCount();
            MekanismUtils.logMismatchedStackSize(this.shrinkStack(amountUsed, Action.EXECUTE), amountUsed);
        }
    }

    public void fillTank() {
        ChemicalInventorySlot.fillChemicalTank(this, this.chemicalTank, this.getCapability());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void fillChemicalTank(IInventorySlot slot, IChemicalTank<CHEMICAL, STACK> chemicalTank, @Nullable IChemicalHandler<CHEMICAL, STACK> handler) {
        if (!slot.isEmpty() && chemicalTank.getNeeded() > 0L) {
            ChemicalInventorySlot.fillChemicalTankFromItem(slot, chemicalTank, handler);
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean fillChemicalTankFromItem(IInventorySlot slot, IChemicalTank<CHEMICAL, STACK> chemicalTank, @Nullable IChemicalHandler<CHEMICAL, STACK> handler) {
        if (handler != null) {
            long toExtract;
            long l = toExtract = chemicalTank.isEmpty() ? handler.extractChemical(chemicalTank.getCapacity(), Action.SIMULATE) : (long)handler.extractChemical((long)ChemicalUtil.copyWithAmount(chemicalTank.getStack(), chemicalTank.getNeeded()), Action.SIMULATE);
            if (!toExtract.isEmpty()) {
                long extractedChemical;
                long simulatedRemainder = chemicalTank.insert(toExtract, Action.SIMULATE, AutomationType.INTERNAL);
                toExtract.shrink(simulatedRemainder.getAmount());
                if (!toExtract.isEmpty() && !(extractedChemical = handler.extractChemical(toExtract, Action.EXECUTE)).isEmpty()) {
                    MekanismUtils.logMismatchedStackSize(chemicalTank.insert(extractedChemical, Action.EXECUTE, AutomationType.INTERNAL).getAmount(), 0L);
                    slot.onContentsChanged();
                    return true;
                }
            }
        }
        return false;
    }

    public void drainTank() {
        ChemicalInventorySlot.drainChemicalTank(this, this.chemicalTank, this.getCapability());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void drainChemicalTank(IInventorySlot slot, IChemicalTank<CHEMICAL, STACK> chemicalTank, @Nullable IChemicalHandler<CHEMICAL, STACK> handler) {
        STACK extractedChemical;
        long amount;
        STACK storedChemical;
        STACK simulatedRemainder;
        long remainder;
        if (!(slot.isEmpty() || chemicalTank.isEmpty() || handler == null || (remainder = ((ChemicalStack)(simulatedRemainder = handler.insertChemical(storedChemical = chemicalTank.getStack(), Action.SIMULATE))).getAmount()) >= (amount = ((ChemicalStack)storedChemical).getAmount()) || ((ChemicalStack)(extractedChemical = chemicalTank.extract(amount - remainder, Action.EXECUTE, AutomationType.INTERNAL))).isEmpty())) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)handler.insertChemical(extractedChemical, Action.EXECUTE)).getAmount(), 0L);
            slot.onContentsChanged();
        }
    }
}

