/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockRadioactiveWasteBarrel;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ItemBlockRadioactiveWasteBarrel
extends ItemBlockTooltip<BlockRadioactiveWasteBarrel> {
    public ItemBlockRadioactiveWasteBarrel(BlockRadioactiveWasteBarrel block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    protected void addStats(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)MekanismLang.CAPACITY_MB.translateColored(EnumColor.INDIGO, EnumColor.GRAY, TextUtils.format(MekanismConfig.general.radioactiveWasteBarrelMaxGas.get())));
        int ticks = MekanismConfig.general.radioactiveWasteBarrelProcessTicks.get();
        long decayAmount = MekanismConfig.general.radioactiveWasteBarrelDecayAmount.get();
        if (decayAmount == 0L || ticks == 1) {
            tooltip.add((Component)MekanismLang.WASTE_BARREL_DECAY_RATE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, TextUtils.format(decayAmount)));
        } else {
            tooltip.add((Component)MekanismLang.WASTE_BARREL_DECAY_RATE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, TextUtils.format(UnitDisplayUtils.roundDecimals((double)decayAmount / (double)ticks, 4))));
            tooltip.add((Component)MekanismLang.WASTE_BARREL_DECAY_RATE_ACTUAL.translateColored(EnumColor.INDIGO, EnumColor.GRAY, TextUtils.format(decayAmount), EnumColor.GRAY, TextUtils.format(ticks)));
        }
    }
}

