/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import mekanism.common.lib.distribution.SplitInfo;

public abstract class Target<HANDLER, TYPE extends Number, EXTRA> {
    protected final Collection<HANDLER> handlers;
    protected final Collection<HandlerType<HANDLER, TYPE>> needed;
    private int handlerCount = 0;
    protected EXTRA extra;

    protected Target() {
        this.handlers = new LinkedList<HANDLER>();
        this.needed = new LinkedList<HandlerType<HANDLER, TYPE>>();
    }

    protected Target(Collection<HANDLER> allHandlers) {
        this.handlers = Collections.unmodifiableCollection(allHandlers);
        this.needed = new ArrayList<HandlerType<HANDLER, TYPE>>(allHandlers.size() / 2);
        this.handlerCount = allHandlers.size();
    }

    protected Target(int expectedSize) {
        this.handlers = new ArrayList<HANDLER>(expectedSize);
        this.needed = new ArrayList<HandlerType<HANDLER, TYPE>>(expectedSize / 2);
    }

    public void addHandler(HANDLER handler) {
        this.handlers.add(handler);
        ++this.handlerCount;
    }

    public int getHandlerCount() {
        return this.handlerCount;
    }

    public void sendRemainingSplit(SplitInfo<TYPE> splitInfo) {
        if (!this.needed.isEmpty() && !splitInfo.isZero(splitInfo.getRemainderAmount())) {
            Iterator<HandlerType<HANDLER, TYPE>> iterator = this.needed.iterator();
            while (iterator.hasNext()) {
                TYPE remainderAmount = splitInfo.getRemainderAmount();
                if (splitInfo.isZero(remainderAmount)) {
                    return;
                }
                HandlerType<HANDLER, TYPE> needInfo = iterator.next();
                TYPE amountNeeded = needInfo.amount();
                if (((Comparable)amountNeeded).compareTo(remainderAmount) <= 0) {
                    this.acceptAmount(needInfo.handler(), splitInfo, amountNeeded);
                    iterator.remove();
                    continue;
                }
                splitInfo.decrementTargets = false;
                this.acceptAmount(needInfo.handler(), splitInfo, remainderAmount);
                splitInfo.decrementTargets = true;
            }
            if (!splitInfo.isZero(splitInfo.getUnsent())) {
                for (HandlerType<HANDLER, TYPE> recipient : this.needed) {
                    TYPE remaining = splitInfo.getUnsent();
                    if (splitInfo.isZero(remaining)) {
                        return;
                    }
                    this.acceptAmount(recipient.handler(), splitInfo, remaining);
                }
            }
        }
    }

    protected abstract void acceptAmount(HANDLER var1, SplitInfo<TYPE> var2, TYPE var3);

    protected abstract TYPE simulate(HANDLER var1, EXTRA var2);

    public void sendPossible(EXTRA toSend, SplitInfo<TYPE> splitInfo) {
        if (splitInfo.isZero(splitInfo.getShareAmount())) {
            for (HANDLER entry : this.handlers) {
                TYPE amountNeeded = this.simulate(entry, toSend);
                if (splitInfo.isZero(amountNeeded)) continue;
                this.needed.add(new HandlerType<HANDLER, TYPE>(entry, amountNeeded));
            }
        } else {
            for (HANDLER entry : this.handlers) {
                TYPE amountNeeded = this.simulate(entry, toSend);
                if (((Comparable)amountNeeded).compareTo(splitInfo.getShareAmount()) <= 0) {
                    if (splitInfo.isZero(amountNeeded)) continue;
                    this.acceptAmount(entry, splitInfo, amountNeeded);
                    continue;
                }
                this.needed.add(new HandlerType<HANDLER, TYPE>(entry, amountNeeded));
            }
        }
    }

    public void shiftNeeded(SplitInfo<TYPE> splitInfo) {
        if (splitInfo.isZero(splitInfo.getShareAmount())) {
            return;
        }
        Iterator<HandlerType<HANDLER, TYPE>> iterator = this.needed.iterator();
        while (iterator.hasNext()) {
            HandlerType<HANDLER, TYPE> needInfo = iterator.next();
            TYPE amountNeeded = needInfo.amount();
            if (((Comparable)amountNeeded).compareTo(splitInfo.getShareAmount()) > 0) continue;
            this.acceptAmount(needInfo.handler(), splitInfo, amountNeeded);
            iterator.remove();
        }
    }

    protected record HandlerType<HANDLER, TYPE extends Number>(HANDLER handler, TYPE amount) {
    }
}

