/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.IFrequency;
import mekanism.api.security.SecurityMode;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Frequency
implements IFrequency {
    protected boolean dirty;
    private boolean removed;
    private String name;
    @Nullable
    private UUID ownerUUID;
    private String ownerName;
    private boolean valid = true;
    private SecurityMode securityMode;
    private final FrequencyType<?> frequencyType;

    protected static <FREQ extends Frequency> Products.P3<RecordCodecBuilder.Mu<FREQ>, String, Optional<UUID>, SecurityMode> baseCodec(RecordCodecBuilder.Instance<FREQ> instance) {
        return instance.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("name").forGetter(Frequency::getName), (App)UUIDUtil.CODEC.optionalFieldOf("owner").forGetter(freq -> Optional.ofNullable(freq.getOwner())), (App)SecurityMode.CODEC.fieldOf("security_mode").forGetter(Frequency::getSecurity));
    }

    protected static <BUF extends ByteBuf, FREQ extends Frequency> StreamCodec<BUF, FREQ> baseStreamCodec(FrequencyConstructor<FREQ> constructor) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Frequency::getName, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), freq -> Optional.ofNullable(freq.getOwner()), (StreamCodec)ByteBufCodecs.stringUtf8((int)PacketUtils.LAST_USERNAME_LENGTH), Frequency::getOwnerName, SecurityMode.STREAM_CODEC, Frequency::getSecurity, (name, owner, ownerName, security) -> constructor.create((String)name, owner.orElse(null), (String)ownerName, (SecurityMode)security));
    }

    protected Frequency(FrequencyType<?> frequencyType, String name, @Nullable UUID owner, SecurityMode securityMode) {
        this.frequencyType = frequencyType;
        this.name = name;
        this.securityMode = securityMode;
        this.setOwnerUUID(owner);
    }

    protected Frequency(FrequencyType<?> frequencyType, String name, @Nullable UUID owner, String ownerName, SecurityMode securityMode) {
        this.frequencyType = frequencyType;
        this.name = name;
        this.ownerUUID = owner;
        this.ownerName = ownerName;
        this.securityMode = securityMode;
    }

    public boolean tick(boolean tickingNormally) {
        return this.dirty;
    }

    public void onRemove() {
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean onDeactivate(BlockEntity tile) {
        return false;
    }

    public boolean update(BlockEntity tile) {
        return false;
    }

    public FrequencyType<?> getType() {
        return this.frequencyType;
    }

    public Object getKey() {
        return this.name;
    }

    @Override
    public final SecurityMode getSecurity() {
        return this.securityMode;
    }

    public void setSecurityMode(SecurityMode securityMode) {
        if (this.securityMode != securityMode) {
            this.securityMode = securityMode;
            this.dirty = true;
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.ownerUUID;
    }

    public boolean ownerMatches(UUID toCheck) {
        return Objects.equals(this.ownerUUID, toCheck);
    }

    @NotNull
    public String getOwnerName() {
        return this.ownerName;
    }

    private void setOwnerUUID(@Nullable UUID uuid) {
        this.ownerUUID = uuid;
        this.ownerName = MekanismUtils.getLastKnownUsername(this.ownerUUID);
    }

    public int getSyncHash() {
        return this.hashCode();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.name.hashCode();
        if (this.ownerUUID != null) {
            code = 31 * code + this.ownerUUID.hashCode();
        }
        if (this.frequencyType != FrequencyType.SECURITY) {
            code = 31 * code + this.securityMode.ordinal();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Frequency) {
            Frequency other = (Frequency)obj;
            if (this.frequencyType == FrequencyType.SECURITY || this.securityMode == other.securityMode) {
                return this.ownerUUID != null && this.name.equals(other.name) && this.ownerUUID.equals(other.ownerUUID);
            }
        }
        return false;
    }

    public FrequencyIdentity getIdentity() {
        return new FrequencyIdentity(this.getKey(), this.securityMode, this.ownerUUID);
    }

    @FunctionalInterface
    protected static interface FrequencyConstructor<FREQ extends Frequency> {
        public FREQ create(String var1, @Nullable UUID var2, String var3, SecurityMode var4);
    }

    public record FrequencyIdentity(Object key, SecurityMode securityMode, @Nullable UUID ownerUUID) {
    }
}

