/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.IntFunction;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.to_client.player_data.PacketPlayerData;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketGearStateUpdate(GearType gearType, UUID uuid, boolean state) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketGearStateUpdate> TYPE = new CustomPacketPayload.Type(Mekanism.rl("update_gear"));
    public static final StreamCodec<ByteBuf, PacketGearStateUpdate> STREAM_CODEC = StreamCodec.composite(GearType.STREAM_CODEC, PacketGearStateUpdate::gearType, (StreamCodec)UUIDUtil.STREAM_CODEC, PacketGearStateUpdate::uuid, (StreamCodec)ByteBufCodecs.BOOL, PacketGearStateUpdate::state, PacketGearStateUpdate::new);

    @NotNull
    public CustomPacketPayload.Type<PacketGearStateUpdate> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        switch (this.gearType.ordinal()) {
            case 0: {
                Mekanism.playerState.setJetpackState(this.uuid, this.state, false);
                break;
            }
            case 1: {
                Mekanism.playerState.setScubaMaskState(this.uuid, this.state, false);
                break;
            }
            case 2: {
                Mekanism.playerState.setGravitationalModulationState(this.uuid, this.state, false);
            }
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)context.player(), (CustomPacketPayload)new PacketPlayerData(this.uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static enum GearType {
        JETPACK,
        SCUBA_MASK,
        GRAVITATIONAL_MODULATOR;

        public static final IntFunction<GearType> BY_ID;
        public static final StreamCodec<ByteBuf, GearType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])GearType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

