/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMekanismRecipeTypeProvider<VANILLA_INPUT extends RecipeInput, RECIPE extends MekanismRecipe<VANILLA_INPUT>, INPUT_CACHE extends IInputRecipeCache> {
    default public ResourceLocation getRegistryName() {
        return this.getRecipeType().getRegistryName();
    }

    public MekanismRecipeType<VANILLA_INPUT, RECIPE, INPUT_CACHE> getRecipeType();

    default public INPUT_CACHE getInputCache() {
        return this.getRecipeType().getInputCache();
    }

    @NotNull
    default public List<RecipeHolder<RECIPE>> getRecipes(@Nullable Level world) {
        return this.getRecipeType().getRecipes(world);
    }

    @NotNull
    default public List<RecipeHolder<RECIPE>> getRecipes(RecipeManager recipeManager, @Nullable Level world) {
        return this.getRecipeType().getRecipes(recipeManager, world);
    }

    default public Stream<RecipeHolder<RECIPE>> stream(@Nullable Level world) {
        return this.getRecipes(world).stream();
    }

    @Nullable
    default public RECIPE findFirst(@Nullable Level world, Predicate<RECIPE> matchCriteria) {
        for (RecipeHolder<RECIPE> recipeRecipeHolder : this.getRecipes(world)) {
            MekanismRecipe value = (MekanismRecipe)recipeRecipeHolder.value();
            if (!matchCriteria.test(value)) continue;
            return (RECIPE)value;
        }
        return null;
    }

    default public boolean contains(@Nullable Level world, Predicate<RECIPE> matchCriteria) {
        for (RecipeHolder<RECIPE> holder : this.getRecipes(world)) {
            if (!matchCriteria.test((MekanismRecipe)holder.value())) continue;
            return true;
        }
        return false;
    }
}

