/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.ItemStackToPigmentRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.PaintingRecipe;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.basic.BasicSmeltingRecipe;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.vanilla_input.BiChemicalRecipeInput;
import mekanism.api.recipes.vanilla_input.ReactionRecipeInput;
import mekanism.api.recipes.vanilla_input.RotaryRecipeInput;
import mekanism.api.recipes.vanilla_input.SingleBoxedChemicalInput;
import mekanism.api.recipes.vanilla_input.SingleChemicalRecipeInput;
import mekanism.api.recipes.vanilla_input.SingleFluidChemicalRecipeInput;
import mekanism.api.recipes.vanilla_input.SingleFluidRecipeInput;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import mekanism.client.MekanismClient;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.cache.ChemicalCrystallizerInputRecipeCache;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.cache.RotaryInputRecipeCache;
import mekanism.common.registration.impl.RecipeTypeDeferredRegister;
import mekanism.common.registration.impl.RecipeTypeRegistryObject;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekanismRecipeType<VANILLA_INPUT extends RecipeInput, RECIPE extends MekanismRecipe<VANILLA_INPUT>, INPUT_CACHE extends IInputRecipeCache>
implements RecipeType<RECIPE>,
IMekanismRecipeTypeProvider<VANILLA_INPUT, RECIPE, INPUT_CACHE> {
    public static final RecipeTypeDeferredRegister RECIPE_TYPES = new RecipeTypeDeferredRegister("mekanism");
    public static final RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> CRUSHING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_CRUSHING, recipeType -> new InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>((MekanismRecipeType<?, ItemStackToItemStackRecipe, ?>)recipeType, ItemStackToItemStackRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> ENRICHING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_ENRICHING, recipeType -> new InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>((MekanismRecipeType<?, ItemStackToItemStackRecipe, ?>)recipeType, ItemStackToItemStackRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> SMELTING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_SMELTING, recipeType -> new InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>((MekanismRecipeType<?, ItemStackToItemStackRecipe, ?>)recipeType, ItemStackToItemStackRecipe::getInput));
    public static final RecipeTypeRegistryObject<BiChemicalRecipeInput<Gas, GasStack>, ChemicalInfuserRecipe, InputRecipeCache.EitherSideChemical<Gas, GasStack, ChemicalInfuserRecipe>> CHEMICAL_INFUSING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_CHEMICAL_INFUSING, InputRecipeCache.EitherSideChemical::new);
    public static final RecipeTypeRegistryObject<RecipeInput, CombinerRecipe, InputRecipeCache.DoubleItem<CombinerRecipe>> COMBINING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_COMBINING, recipeType -> new InputRecipeCache.DoubleItem<CombinerRecipe>((MekanismRecipeType<?, CombinerRecipe, ?>)recipeType, CombinerRecipe::getMainInput, CombinerRecipe::getExtraInput));
    public static final RecipeTypeRegistryObject<SingleFluidRecipeInput, ElectrolysisRecipe, InputRecipeCache.SingleFluid<ElectrolysisRecipe>> SEPARATING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_SEPARATING, recipeType -> new InputRecipeCache.SingleFluid<ElectrolysisRecipe>((MekanismRecipeType<?, ElectrolysisRecipe, ?>)recipeType, ElectrolysisRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleFluidChemicalRecipeInput<Slurry, SlurryStack>, FluidSlurryToSlurryRecipe, InputRecipeCache.FluidChemical<Slurry, SlurryStack, FluidSlurryToSlurryRecipe>> WASHING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_WASHING, recipeType -> new InputRecipeCache.FluidChemical((MekanismRecipeType<?, FluidSlurryToSlurryRecipe, ?>)recipeType, FluidSlurryToSlurryRecipe::getFluidInput, FluidSlurryToSlurryRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<SingleFluidRecipeInput, FluidToFluidRecipe, InputRecipeCache.SingleFluid<FluidToFluidRecipe>> EVAPORATING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_EVAPORATING, recipeType -> new InputRecipeCache.SingleFluid<FluidToFluidRecipe>((MekanismRecipeType<?, FluidToFluidRecipe, ?>)recipeType, FluidToFluidRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleChemicalRecipeInput<Gas, GasStack>, GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> ACTIVATING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_ACTIVATING, recipeType -> new InputRecipeCache.SingleChemical((MekanismRecipeType<?, GasToGasRecipe, ?>)recipeType, GasToGasRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleChemicalRecipeInput<Gas, GasStack>, GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> CENTRIFUGING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_CENTRIFUGING, recipeType -> new InputRecipeCache.SingleChemical((MekanismRecipeType<?, GasToGasRecipe, ?>)recipeType, GasToGasRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleBoxedChemicalInput, ChemicalCrystallizerRecipe, ChemicalCrystallizerInputRecipeCache> CRYSTALLIZING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_CRYSTALLIZING, ChemicalCrystallizerInputRecipeCache::new);
    public static final RecipeTypeRegistryObject<SingleItemChemicalRecipeInput<Gas, GasStack>, ChemicalDissolutionRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ChemicalDissolutionRecipe>> DISSOLUTION = MekanismRecipeType.register(MekanismRecipeTypes.NAME_DISSOLUTION, recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<?, ChemicalDissolutionRecipe, ?>)recipeType, ChemicalDissolutionRecipe::getItemInput, ChemicalDissolutionRecipe::getGasInput));
    public static final RecipeTypeRegistryObject<SingleItemChemicalRecipeInput<Gas, GasStack>, ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> COMPRESSING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_COMPRESSING, recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<?, ItemStackGasToItemStackRecipe, ?>)recipeType, ItemStackGasToItemStackRecipe::getItemInput, ItemStackGasToItemStackRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<SingleItemChemicalRecipeInput<Gas, GasStack>, ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> PURIFYING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_PURIFYING, recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<?, ItemStackGasToItemStackRecipe, ?>)recipeType, ItemStackGasToItemStackRecipe::getItemInput, ItemStackGasToItemStackRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<SingleItemChemicalRecipeInput<Gas, GasStack>, ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> INJECTING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_INJECTING, recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<?, ItemStackGasToItemStackRecipe, ?>)recipeType, ItemStackGasToItemStackRecipe::getItemInput, ItemStackGasToItemStackRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<SingleItemChemicalRecipeInput<Gas, GasStack>, NucleosynthesizingRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, NucleosynthesizingRecipe>> NUCLEOSYNTHESIZING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_NUCLEOSYNTHESIZING, recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<?, NucleosynthesizingRecipe, ?>)recipeType, NucleosynthesizingRecipe::getItemInput, NucleosynthesizingRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToEnergyRecipe, InputRecipeCache.SingleItem<ItemStackToEnergyRecipe>> ENERGY_CONVERSION = MekanismRecipeType.register(MekanismRecipeTypes.NAME_ENERGY_CONVERSION, recipeType -> new InputRecipeCache.SingleItem<ItemStackToEnergyRecipe>((MekanismRecipeType<?, ItemStackToEnergyRecipe, ?>)recipeType, ItemStackToEnergyRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToGasRecipe, InputRecipeCache.SingleItem<ItemStackToGasRecipe>> GAS_CONVERSION = MekanismRecipeType.register(MekanismRecipeTypes.NAME_GAS_CONVERSION, recipeType -> new InputRecipeCache.SingleItem<ItemStackToGasRecipe>((MekanismRecipeType<?, ItemStackToGasRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToGasRecipe, InputRecipeCache.SingleItem<ItemStackToGasRecipe>> OXIDIZING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_OXIDIZING, recipeType -> new InputRecipeCache.SingleItem<ItemStackToGasRecipe>((MekanismRecipeType<?, ItemStackToGasRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToInfuseTypeRecipe, InputRecipeCache.SingleItem<ItemStackToInfuseTypeRecipe>> INFUSION_CONVERSION = MekanismRecipeType.register(MekanismRecipeTypes.NAME_INFUSION_CONVERSION, recipeType -> new InputRecipeCache.SingleItem<ItemStackToInfuseTypeRecipe>((MekanismRecipeType<?, ItemStackToInfuseTypeRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToPigmentRecipe, InputRecipeCache.SingleItem<ItemStackToPigmentRecipe>> PIGMENT_EXTRACTING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_PIGMENT_EXTRACTING, recipeType -> new InputRecipeCache.SingleItem<ItemStackToPigmentRecipe>((MekanismRecipeType<?, ItemStackToPigmentRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final RecipeTypeRegistryObject<BiChemicalRecipeInput<Pigment, PigmentStack>, PigmentMixingRecipe, InputRecipeCache.EitherSideChemical<Pigment, PigmentStack, PigmentMixingRecipe>> PIGMENT_MIXING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_PIGMENT_MIXING, InputRecipeCache.EitherSideChemical::new);
    public static final RecipeTypeRegistryObject<SingleItemChemicalRecipeInput<InfuseType, InfusionStack>, MetallurgicInfuserRecipe, InputRecipeCache.ItemChemical<InfuseType, InfusionStack, MetallurgicInfuserRecipe>> METALLURGIC_INFUSING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_METALLURGIC_INFUSING, recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<?, MetallurgicInfuserRecipe, ?>)recipeType, MetallurgicInfuserRecipe::getItemInput, MetallurgicInfuserRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<SingleItemChemicalRecipeInput<Pigment, PigmentStack>, PaintingRecipe, InputRecipeCache.ItemChemical<Pigment, PigmentStack, PaintingRecipe>> PAINTING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_PAINTING, recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<?, PaintingRecipe, ?>)recipeType, PaintingRecipe::getItemInput, PaintingRecipe::getChemicalInput));
    public static final RecipeTypeRegistryObject<ReactionRecipeInput, PressurizedReactionRecipe, InputRecipeCache.ItemFluidChemical<Gas, GasStack, PressurizedReactionRecipe>> REACTION = MekanismRecipeType.register(MekanismRecipeTypes.NAME_REACTION, recipeType -> new InputRecipeCache.ItemFluidChemical((MekanismRecipeType<?, PressurizedReactionRecipe, ?>)recipeType, PressurizedReactionRecipe::getInputSolid, PressurizedReactionRecipe::getInputFluid, PressurizedReactionRecipe::getInputGas));
    public static final RecipeTypeRegistryObject<RotaryRecipeInput, RotaryRecipe, RotaryInputRecipeCache> ROTARY = MekanismRecipeType.register(MekanismRecipeTypes.NAME_ROTARY, RotaryInputRecipeCache::new);
    public static final RecipeTypeRegistryObject<SingleRecipeInput, SawmillRecipe, InputRecipeCache.SingleItem<SawmillRecipe>> SAWING = MekanismRecipeType.register(MekanismRecipeTypes.NAME_SAWING, recipeType -> new InputRecipeCache.SingleItem<SawmillRecipe>((MekanismRecipeType<?, SawmillRecipe, ?>)recipeType, SawmillRecipe::getInput));
    private List<RecipeHolder<RECIPE>> cachedRecipes = Collections.emptyList();
    private final ResourceLocation registryName;
    private final INPUT_CACHE inputCache;

    private static <VANILLA_INPUT extends RecipeInput, RECIPE extends MekanismRecipe<VANILLA_INPUT>, INPUT_CACHE extends IInputRecipeCache> RecipeTypeRegistryObject<VANILLA_INPUT, RECIPE, INPUT_CACHE> register(ResourceLocation name, Function<MekanismRecipeType<VANILLA_INPUT, RECIPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        if (!"mekanism".equals(name.getNamespace())) {
            throw new IllegalStateException("Name must be in mekanism namespace");
        }
        return RECIPE_TYPES.registerMek(name.getPath(), registryName -> new MekanismRecipeType((ResourceLocation)registryName, inputCacheCreator));
    }

    public static void clearCache() {
        for (Holder entry : RECIPE_TYPES.getEntries()) {
            Object object = entry.value();
            if (!(object instanceof MekanismRecipeType)) continue;
            MekanismRecipeType recipeType = (MekanismRecipeType)object;
            recipeType.clearCaches();
        }
    }

    private MekanismRecipeType(ResourceLocation name, Function<MekanismRecipeType<VANILLA_INPUT, RECIPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        this.registryName = name;
        this.inputCache = (IInputRecipeCache)inputCacheCreator.apply(this);
    }

    public String toString() {
        return this.registryName.toString();
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public MekanismRecipeType<VANILLA_INPUT, RECIPE, INPUT_CACHE> getRecipeType() {
        return this;
    }

    private void clearCaches() {
        this.cachedRecipes = Collections.emptyList();
        this.inputCache.clear();
    }

    @Override
    public INPUT_CACHE getInputCache() {
        return this.inputCache;
    }

    @Nullable
    private Level getLevel(@Nullable Level level) {
        if (level == null) {
            if (FMLEnvironment.dist.isClient()) {
                return MekanismClient.tryGetClientWorld();
            }
            return ServerLifecycleHooks.getCurrentServer().overworld();
        }
        return level;
    }

    @Override
    @NotNull
    public List<RecipeHolder<RECIPE>> getRecipes(@Nullable Level world) {
        if ((world = this.getLevel(world)) == null) {
            return Collections.emptyList();
        }
        return this.getRecipes(world.getRecipeManager(), world);
    }

    @Override
    @NotNull
    public List<RecipeHolder<RECIPE>> getRecipes(RecipeManager recipeManager, @Nullable Level world) {
        if (this.cachedRecipes.isEmpty()) {
            ArrayList<RecipeHolder> recipes = recipeManager.getAllRecipesFor((RecipeType)this);
            if (this == SMELTING.get()) {
                if ((world = this.getLevel(world)) == null) {
                    return recipes.stream().filter(recipe -> !((MekanismRecipe)recipe.value()).isIncomplete()).toList();
                }
                recipes = new ArrayList<RecipeHolder>(recipes);
                for (RecipeHolder smeltingRecipe : recipeManager.getAllRecipesFor(RecipeType.SMELTING)) {
                    NonNullList ingredients;
                    ItemStack recipeOutput = ((SmeltingRecipe)smeltingRecipe.value()).getResultItem((HolderLookup.Provider)world.registryAccess());
                    if (((SmeltingRecipe)smeltingRecipe.value()).isSpecial() || ((SmeltingRecipe)smeltingRecipe.value()).isIncomplete() || recipeOutput.isEmpty() || (ingredients = ((SmeltingRecipe)smeltingRecipe.value()).getIngredients()).isEmpty()) continue;
                    ItemStackIngredient input = IngredientCreatorAccess.item().from(CompoundIngredient.of((Ingredient[])((Ingredient[])ingredients.toArray(Ingredient[]::new))));
                    recipes.add(new RecipeHolder(RecipeViewerUtils.synthetic(smeltingRecipe.id(), "mekanism_generated"), this.castRecipe(new BasicSmeltingRecipe(input, recipeOutput))));
                }
            }
            this.cachedRecipes = recipes.stream().filter(recipe -> !((MekanismRecipe)recipe.value()).isIncomplete()).toList();
        }
        return this.cachedRecipes;
    }

    private RECIPE castRecipe(MekanismRecipe<?> o) {
        if (o.getType() != this) {
            throw new IllegalArgumentException("Wrong recipe type");
        }
        return (RECIPE)o;
    }

    public static <I extends RecipeInput, RECIPE_TYPE extends Recipe<I>> Optional<RecipeHolder<RECIPE_TYPE>> getRecipeFor(RecipeType<RECIPE_TYPE> recipeType, I input, Level level) {
        return level.getRecipeManager().getRecipeFor(recipeType, input, level).filter(recipe -> recipe.value().isSpecial() || !recipe.value().isIncomplete());
    }

    public static Optional<RecipeHolder<?>> byKey(Level level, ResourceLocation id) {
        return level.getRecipeManager().byKey(id).filter(recipe -> recipe.value().isSpecial() || !recipe.value().isIncomplete());
    }
}

