/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredients;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.CompoundChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.SingleChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.TagChemicalIngredient;
import net.minecraft.core.Registry;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class ChemicalIngredientUtil {
    private ChemicalIngredientUtil() {
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>, SINGLE extends SingleChemicalIngredient<CHEMICAL, INGREDIENT>, TAG extends TagChemicalIngredient<CHEMICAL, INGREDIENT>> MapCodec<INGREDIENT> singleOrTagCodec(MapCodec<SINGLE> singleCodec, MapCodec<TAG> tagCodec) {
        return NeoForgeExtraCodecs.xor(singleCodec, tagCodec).flatXmap(either -> DataResult.success((Object)((IChemicalIngredient)either.map(i -> i, i -> i))), ingredient -> {
            if (ingredient instanceof SingleChemicalIngredient) {
                return DataResult.success((Object)Either.left((Object)((SingleChemicalIngredient)ingredient)));
            }
            if (ingredient instanceof TagChemicalIngredient) {
                return DataResult.success((Object)Either.right((Object)((TagChemicalIngredient)ingredient)));
            }
            return DataResult.error(() -> "Basic chemical ingredient should be either a chemical or a tag!");
        });
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>> MapCodec<INGREDIENT> makeMapCodec(Registry<MapCodec<? extends INGREDIENT>> typeRegistry, MapCodec<INGREDIENT> singleOrTagCodec) {
        return NeoForgeExtraCodecs.dispatchMapOrElse((Codec)typeRegistry.byNameCodec(), IChemicalIngredient::codec, Function.identity(), singleOrTagCodec).xmap(either -> (IChemicalIngredient)either.map(Function.identity(), Function.identity()), ingredient -> {
            if (ingredient instanceof SingleChemicalIngredient || ingredient instanceof TagChemicalIngredient) {
                return Either.right((Object)ingredient);
            }
            return Either.left((Object)ingredient);
        }).validate(ingredient -> {
            if (ingredient.isEmpty()) {
                return DataResult.error(() -> "Cannot serialize empty chemical ingredient using the map codec");
            }
            return DataResult.success((Object)ingredient);
        });
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>> Codec<INGREDIENT> codec(Codec<List<INGREDIENT>> listCodec, Codec<INGREDIENT> mapCodecCodec, Function<List<? extends INGREDIENT>, INGREDIENT> compoundCreator) {
        return Codec.either(listCodec, mapCodecCodec).xmap(either -> (IChemicalIngredient)either.map(compoundCreator, Function.identity()), ingredient -> {
            if (ingredient instanceof CompoundChemicalIngredient) {
                CompoundChemicalIngredient compound = (CompoundChemicalIngredient)ingredient;
                return Either.left(compound.children());
            }
            if (ingredient.isEmpty()) {
                return Either.left(Collections.emptyList());
            }
            return Either.right((Object)ingredient);
        });
    }
}

